/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PhotoFilter: ImageVector
    get() {
        if (_photoFilter != null) {
            return _photoFilter!!
        }
        _photoFilter = materialIcon(name = "Sharp.PhotoFilter") {
            materialPath {
                moveTo(19.0f, 10.0f)
                verticalLineToRelative(9.0f)
                lineTo(4.98f, 19.0f)
                lineTo(4.98f, 5.0f)
                horizontalLineToRelative(9.0f)
                lineTo(13.98f, 3.0f)
                lineTo(3.0f, 3.0f)
                verticalLineToRelative(18.0f)
                horizontalLineToRelative(18.0f)
                lineTo(21.0f, 10.0f)
                horizontalLineToRelative(-2.0f)
                close()
                moveTo(17.0f, 10.0f)
                lineToRelative(0.94f, -2.06f)
                lineTo(20.0f, 7.0f)
                lineToRelative(-2.06f, -0.94f)
                lineTo(17.0f, 4.0f)
                lineToRelative(-0.94f, 2.06f)
                lineTo(14.0f, 7.0f)
                lineToRelative(2.06f, 0.94f)
                lineTo(17.0f, 10.0f)
                close()
                moveTo(13.25f, 10.75f)
                lineTo(12.0f, 8.0f)
                lineToRelative(-1.25f, 2.75f)
                lineTo(8.0f, 12.0f)
                lineToRelative(2.75f, 1.25f)
                lineTo(12.0f, 16.0f)
                lineToRelative(1.25f, -2.75f)
                lineTo(16.0f, 12.0f)
                lineToRelative(-2.75f, -1.25f)
                close()
            }
        }
        return _photoFilter!!
    }

private var _photoFilter: ImageVector? = null
