/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.NightShelter: ImageVector
    get() {
        if (_nightShelter != null) {
            return _nightShelter!!
        }
        _nightShelter = materialIcon(name = "Sharp.NightShelter") {
            materialPath {
                moveTo(12.0f, 3.0f)
                lineTo(4.0f, 9.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(16.0f)
                verticalLineTo(9.0f)
                lineTo(12.0f, 3.0f)
                close()
                moveTo(9.75f, 12.5f)
                curveToRelative(0.69f, 0.0f, 1.25f, 0.56f, 1.25f, 1.25f)
                reflectiveCurveTo(10.44f, 15.0f, 9.75f, 15.0f)
                reflectiveCurveTo(8.5f, 14.44f, 8.5f, 13.75f)
                reflectiveCurveTo(9.06f, 12.5f, 9.75f, 12.5f)
                close()
                moveTo(17.0f, 18.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(-1.5f)
                horizontalLineTo(8.0f)
                verticalLineTo(18.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(-7.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(4.5f)
                horizontalLineToRelative(3.5f)
                verticalLineTo(12.0f)
                horizontalLineTo(17.0f)
                verticalLineTo(18.0f)
                close()
            }
        }
        return _nightShelter!!
    }

private var _nightShelter: ImageVector? = null
