/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.HeadphonesBattery: ImageVector
    get() {
        if (_headphonesBattery != null) {
            return _headphonesBattery!!
        }
        _headphonesBattery = materialIcon(name = "Sharp.HeadphonesBattery") {
            materialPath {
                moveTo(20.0f, 7.0f)
                lineToRelative(0.0f, -1.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 1.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 11.0f)
                lineToRelative(6.0f, 0.0f)
                lineToRelative(0.0f, -11.0f)
                close()
            }
            materialPath {
                moveTo(8.0f, 6.0f)
                curveToRelative(-3.31f, 0.0f, -6.0f, 2.69f, -6.0f, 6.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineTo(3.5f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -2.48f, 2.02f, -4.5f, 4.5f, -4.5f)
                reflectiveCurveToRelative(4.5f, 2.02f, 4.5f, 4.5f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(10.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(-6.0f)
                curveTo(14.0f, 8.69f, 11.31f, 6.0f, 8.0f, 6.0f)
                close()
            }
        }
        return _headphonesBattery!!
    }

private var _headphonesBattery: ImageVector? = null
