/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Dry: ImageVector
    get() {
        if (_dry != null) {
            return _dry!!
        }
        _dry = materialIcon(name = "Sharp.Dry") {
            materialPath {
                moveTo(1.0f, 12.68f)
                verticalLineTo(23.0f)
                horizontalLineToRelative(18.0f)
                verticalLineToRelative(-2.5f)
                horizontalLineToRelative(-7.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(9.0f)
                verticalLineTo(17.0f)
                horizontalLineToRelative(-9.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(-2.5f)
                horizontalLineTo(12.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(8.0f)
                verticalLineTo(10.0f)
                horizontalLineTo(8.86f)
                lineToRelative(1.88f, -3.3f)
                lineTo(9.12f, 5.0f)
                lineTo(1.0f, 12.68f)
                close()
                moveTo(15.65f, 4.86f)
                lineToRelative(-0.07f, -0.07f)
                curveToRelative(-0.57f, -0.62f, -0.82f, -1.41f, -0.67f, -2.2f)
                lineTo(15.0f, 2.0f)
                horizontalLineToRelative(-1.89f)
                lineToRelative(-0.06f, 0.43f)
                curveToRelative(-0.2f, 1.36f, 0.27f, 2.71f, 1.3f, 3.72f)
                lineToRelative(0.07f, 0.06f)
                curveToRelative(0.57f, 0.62f, 0.82f, 1.41f, 0.67f, 2.2f)
                lineTo(14.98f, 9.0f)
                horizontalLineToRelative(1.91f)
                lineToRelative(0.06f, -0.43f)
                curveTo(17.16f, 7.21f, 16.68f, 5.86f, 15.65f, 4.86f)
                close()
                moveTo(19.65f, 4.86f)
                lineToRelative(-0.07f, -0.07f)
                curveToRelative(-0.57f, -0.62f, -0.82f, -1.41f, -0.67f, -2.2f)
                lineTo(19.0f, 2.0f)
                horizontalLineToRelative(-1.89f)
                lineToRelative(-0.06f, 0.43f)
                curveToRelative(-0.2f, 1.36f, 0.27f, 2.71f, 1.3f, 3.72f)
                lineToRelative(0.07f, 0.06f)
                curveToRelative(0.57f, 0.62f, 0.82f, 1.41f, 0.67f, 2.2f)
                lineTo(18.98f, 9.0f)
                horizontalLineToRelative(1.91f)
                lineToRelative(0.06f, -0.43f)
                curveTo(21.16f, 7.21f, 20.68f, 5.86f, 19.65f, 4.86f)
                close()
            }
        }
        return _dry!!
    }

private var _dry: ImageVector? = null
