/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Dangerous: ImageVector
    get() {
        if (_dangerous != null) {
            return _dangerous!!
        }
        _dangerous = materialIcon(name = "Sharp.Dangerous") {
            materialPath {
                moveTo(15.73f, 3.0f)
                horizontalLineTo(8.27f)
                lineTo(3.0f, 8.27f)
                verticalLineToRelative(7.46f)
                lineTo(8.27f, 21.0f)
                horizontalLineToRelative(7.46f)
                lineTo(21.0f, 15.73f)
                verticalLineTo(8.27f)
                lineTo(15.73f, 3.0f)
                close()
                moveTo(16.24f, 14.83f)
                lineToRelative(-1.41f, 1.41f)
                lineTo(12.0f, 13.41f)
                lineToRelative(-2.83f, 2.83f)
                lineToRelative(-1.41f, -1.41f)
                lineTo(10.59f, 12.0f)
                lineTo(7.76f, 9.17f)
                lineToRelative(1.41f, -1.41f)
                lineTo(12.0f, 10.59f)
                lineToRelative(2.83f, -2.83f)
                lineToRelative(1.41f, 1.41f)
                lineTo(13.41f, 12.0f)
                lineTo(16.24f, 14.83f)
                close()
            }
        }
        return _dangerous!!
    }

private var _dangerous: ImageVector? = null
