/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.CallEnd: ImageVector
    get() {
        if (_callEnd != null) {
            return _callEnd!!
        }
        _callEnd = materialIcon(name = "Sharp.CallEnd") {
            materialPath {
                moveTo(3.68f, 16.07f)
                lineToRelative(3.92f, -3.11f)
                verticalLineTo(9.59f)
                curveToRelative(2.85f, -0.93f, 5.94f, -0.93f, 8.8f, 0.0f)
                verticalLineToRelative(3.38f)
                lineToRelative(3.91f, 3.1f)
                lineTo(24.0f, 12.39f)
                curveToRelative(-6.41f, -7.19f, -17.59f, -7.19f, -24.0f, 0.0f)
                lineToRelative(3.68f, 3.68f)
                close()
            }
        }
        return _callEnd!!
    }

private var _callEnd: ImageVector? = null
