/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.WifiLock: ImageVector
    get() {
        if (_wifiLock != null) {
            return _wifiLock!!
        }
        _wifiLock = materialIcon(name = "Rounded.WifiLock") {
            materialPath {
                moveTo(23.21f, 8.24f)
                curveTo(20.22f, 5.6f, 16.3f, 4.0f, 12.0f, 4.0f)
                reflectiveCurveTo(3.78f, 5.6f, 0.79f, 8.24f)
                curveTo(0.35f, 8.63f, 0.32f, 9.3f, 0.73f, 9.71f)
                lineToRelative(5.62f, 5.63f)
                lineToRelative(4.94f, 4.95f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.42f, 0.0f)
                lineToRelative(2.34f, -2.34f)
                verticalLineTo(15.0f)
                curveToRelative(0.0f, -0.45f, 0.09f, -0.88f, 0.23f, -1.29f)
                curveToRelative(0.54f, -1.57f, 2.01f, -2.71f, 3.77f, -2.71f)
                horizontalLineToRelative(2.94f)
                lineToRelative(1.29f, -1.29f)
                curveTo(23.68f, 9.3f, 23.65f, 8.63f, 23.21f, 8.24f)
                close()
            }
            materialPath {
                moveTo(22.0f, 16.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(3.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-3.0f)
                curveTo(23.0f, 16.45f, 22.55f, 16.0f, 22.0f, 16.0f)
                close()
                moveTo(21.0f, 16.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineTo(16.0f)
                close()
            }
        }
        return _wifiLock!!
    }

private var _wifiLock: ImageVector? = null
