/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Storefront: ImageVector
    get() {
        if (_storefront != null) {
            return _storefront!!
        }
        _storefront = materialIcon(name = "Rounded.Storefront") {
            materialPath {
                moveTo(21.9f, 7.89f)
                lineToRelative(-1.05f, -3.37f)
                curveToRelative(-0.22f, -0.9f, -1.0f, -1.52f, -1.91f, -1.52f)
                horizontalLineTo(5.05f)
                curveToRelative(-0.9f, 0.0f, -1.69f, 0.63f, -1.9f, 1.52f)
                lineTo(2.1f, 7.89f)
                curveTo(1.64f, 9.86f, 2.95f, 11.0f, 3.0f, 11.06f)
                verticalLineTo(19.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-7.94f)
                curveTo(22.12f, 9.94f, 22.09f, 8.65f, 21.9f, 7.89f)
                close()
                moveTo(13.0f, 5.0f)
                horizontalLineToRelative(1.96f)
                lineToRelative(0.54f, 3.52f)
                curveTo(15.59f, 9.23f, 15.11f, 10.0f, 14.22f, 10.0f)
                curveTo(13.55f, 10.0f, 13.0f, 9.41f, 13.0f, 8.69f)
                verticalLineTo(5.0f)
                close()
                moveTo(6.44f, 8.86f)
                curveTo(6.36f, 9.51f, 5.84f, 10.0f, 5.23f, 10.0f)
                curveTo(4.3f, 10.0f, 3.88f, 9.03f, 4.04f, 8.36f)
                lineTo(5.05f, 5.0f)
                horizontalLineToRelative(1.97f)
                lineTo(6.44f, 8.86f)
                close()
                moveTo(11.0f, 8.69f)
                curveTo(11.0f, 9.41f, 10.45f, 10.0f, 9.71f, 10.0f)
                curveToRelative(-0.75f, 0.0f, -1.3f, -0.7f, -1.22f, -1.48f)
                lineTo(9.04f, 5.0f)
                horizontalLineTo(11.0f)
                verticalLineTo(8.69f)
                close()
                moveTo(18.77f, 10.0f)
                curveToRelative(-0.61f, 0.0f, -1.14f, -0.49f, -1.21f, -1.14f)
                lineTo(16.98f, 5.0f)
                lineToRelative(1.93f, -0.01f)
                lineToRelative(1.05f, 3.37f)
                curveTo(20.12f, 9.03f, 19.71f, 10.0f, 18.77f, 10.0f)
                close()
            }
        }
        return _storefront!!
    }

private var _storefront: ImageVector? = null
