/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SquareFoot: ImageVector
    get() {
        if (_squareFoot != null) {
            return _squareFoot!!
        }
        _squareFoot = materialIcon(name = "Rounded.SquareFoot") {
            materialPath {
                moveTo(17.66f, 17.66f)
                lineToRelative(-0.71f, 0.71f)
                curveToRelative(-0.2f, 0.2f, -0.51f, 0.2f, -0.71f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.2f, -0.2f, -0.2f, -0.51f, 0.0f, -0.71f)
                lineToRelative(0.71f, -0.71f)
                lineToRelative(-1.94f, -1.94f)
                lineToRelative(-0.71f, 0.71f)
                curveToRelative(-0.2f, 0.2f, -0.51f, 0.2f, -0.71f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.2f, -0.2f, -0.2f, -0.51f, 0.0f, -0.71f)
                lineToRelative(0.71f, -0.71f)
                lineToRelative(-1.94f, -1.94f)
                lineToRelative(-0.71f, 0.71f)
                curveToRelative(-0.2f, 0.2f, -0.51f, 0.2f, -0.71f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.2f, -0.2f, -0.2f, -0.51f, 0.0f, -0.71f)
                lineToRelative(0.71f, -0.71f)
                lineTo(9.7f, 9.7f)
                lineToRelative(-0.71f, 0.71f)
                curveToRelative(-0.2f, 0.2f, -0.51f, 0.2f, -0.71f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.2f, -0.2f, -0.2f, -0.51f, 0.0f, -0.71f)
                lineToRelative(0.71f, -0.71f)
                lineTo(7.05f, 7.05f)
                lineTo(6.34f, 7.76f)
                curveToRelative(-0.2f, 0.2f, -0.51f, 0.2f, -0.71f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.2f, -0.2f, -0.2f, -0.51f, 0.0f, -0.71f)
                lineToRelative(0.71f, -0.71f)
                lineTo(4.85f, 4.85f)
                curveTo(4.54f, 4.54f, 4.0f, 4.76f, 4.0f, 5.21f)
                verticalLineTo(18.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(12.79f)
                curveToRelative(0.45f, 0.0f, 0.67f, -0.54f, 0.35f, -0.85f)
                lineTo(17.66f, 17.66f)
                close()
                moveTo(7.0f, 16.0f)
                verticalLineToRelative(-4.76f)
                lineTo(12.76f, 17.0f)
                horizontalLineTo(8.0f)
                curveTo(7.45f, 17.0f, 7.0f, 16.55f, 7.0f, 16.0f)
                close()
            }
        }
        return _squareFoot!!
    }

private var _squareFoot: ImageVector? = null
