/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.PhonelinkErase: ImageVector
    get() {
        if (_phonelinkErase != null) {
            return _phonelinkErase!!
        }
        _phonelinkErase = materialIcon(name = "Rounded.PhonelinkErase") {
            materialPath {
                moveTo(12.5f, 7.7f)
                curveToRelative(-0.28f, -0.28f, -0.72f, -0.28f, -1.0f, 0.0f)
                lineTo(8.0f, 11.2f)
                lineTo(4.5f, 7.7f)
                curveToRelative(-0.28f, -0.28f, -0.72f, -0.28f, -1.0f, 0.0f)
                reflectiveCurveToRelative(-0.28f, 0.72f, 0.0f, 1.0f)
                lineTo(7.0f, 12.2f)
                lineToRelative(-3.5f, 3.5f)
                curveToRelative(-0.28f, 0.28f, -0.28f, 0.72f, 0.0f, 1.0f)
                reflectiveCurveToRelative(0.72f, 0.28f, 1.0f, 0.0f)
                lineTo(8.0f, 13.2f)
                lineToRelative(3.5f, 3.5f)
                curveToRelative(0.28f, 0.28f, 0.72f, 0.28f, 1.0f, 0.0f)
                reflectiveCurveToRelative(0.28f, -0.72f, 0.0f, -1.0f)
                lineTo(9.0f, 12.2f)
                lineToRelative(3.5f, -3.5f)
                curveToRelative(0.28f, -0.28f, 0.28f, -0.72f, 0.0f, -1.0f)
                close()
                moveTo(19.0f, 1.0f)
                horizontalLineTo(9.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(16.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                reflectiveCurveToRelative(-1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(3.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
            }
        }
        return _phonelinkErase!!
    }

private var _phonelinkErase: ImageVector? = null
