/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Pattern: ImageVector
    get() {
        if (_pattern != null) {
            return _pattern!!
        }
        _pattern = materialIcon(name = "Rounded.Pattern") {
            materialPath {
                moveTo(4.0f, 6.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveTo(7.1f, 8.0f, 6.0f, 8.0f)
                reflectiveCurveTo(4.0f, 7.1f, 4.0f, 6.0f)
                close()
                moveTo(6.0f, 14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveTo(4.9f, 14.0f, 6.0f, 14.0f)
                close()
                moveTo(12.0f, 8.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveTo(10.9f, 8.0f, 12.0f, 8.0f)
                close()
                moveTo(18.0f, 10.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveTo(19.1f, 10.0f, 18.0f, 10.0f)
                close()
                moveTo(17.98f, 16.0f)
                curveToRelative(-0.74f, 0.0f, -1.37f, 0.4f, -1.72f, 1.0f)
                horizontalLineToRelative(-2.54f)
                curveToRelative(-0.34f, -0.6f, -0.98f, -1.0f, -1.72f, -1.0f)
                reflectiveCurveToRelative(-1.37f, 0.4f, -1.72f, 1.0f)
                horizontalLineTo(8.41f)
                lineToRelative(3.07f, -3.07f)
                curveTo(11.65f, 13.97f, 11.82f, 14.0f, 12.0f, 14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                curveToRelative(0.0f, -0.18f, -0.03f, -0.35f, -0.07f, -0.51f)
                lineToRelative(3.56f, -3.56f)
                curveTo(17.65f, 7.97f, 17.82f, 8.0f, 18.0f, 8.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                curveToRelative(0.0f, 0.18f, 0.03f, 0.35f, 0.07f, 0.51f)
                lineToRelative(-3.56f, 3.56f)
                curveTo(12.35f, 10.03f, 12.18f, 10.0f, 12.0f, 10.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                curveToRelative(0.0f, 0.18f, 0.03f, 0.35f, 0.07f, 0.51f)
                lineToRelative(-3.56f, 3.56f)
                curveTo(6.35f, 16.03f, 6.18f, 16.0f, 6.0f, 16.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                curveToRelative(0.74f, 0.0f, 1.37f, -0.4f, 1.72f, -1.0f)
                horizontalLineToRelative(2.57f)
                curveToRelative(0.34f, 0.6f, 0.98f, 1.0f, 1.72f, 1.0f)
                reflectiveCurveToRelative(1.37f, -0.4f, 1.72f, -1.0f)
                horizontalLineToRelative(2.55f)
                curveToRelative(0.34f, 0.6f, 0.98f, 1.0f, 1.72f, 1.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                curveTo(19.98f, 16.9f, 19.08f, 16.0f, 17.98f, 16.0f)
                close()
            }
        }
        return _pattern!!
    }

private var _pattern: ImageVector? = null
