/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.MarkEmailUnread: ImageVector
    get() {
        if (_markEmailUnread != null) {
            return _markEmailUnread!!
        }
        _markEmailUnread = materialIcon(name = "Rounded.MarkEmailUnread") {
            materialPath {
                moveTo(19.0f, 10.0f)
                curveToRelative(1.13f, 0.0f, 2.16f, -0.39f, 3.0f, -1.02f)
                verticalLineTo(18.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                horizontalLineToRelative(10.1f)
                curveTo(14.04f, 4.32f, 14.0f, 4.66f, 14.0f, 5.0f)
                curveToRelative(0.0f, 1.48f, 0.65f, 2.79f, 1.67f, 3.71f)
                lineTo(12.0f, 11.0f)
                lineTo(5.3f, 6.81f)
                curveTo(4.73f, 6.46f, 4.0f, 6.86f, 4.0f, 7.53f)
                curveToRelative(0.0f, 0.29f, 0.15f, 0.56f, 0.4f, 0.72f)
                lineToRelative(7.07f, 4.42f)
                curveToRelative(0.32f, 0.2f, 0.74f, 0.2f, 1.06f, 0.0f)
                lineToRelative(4.77f, -2.98f)
                curveTo(17.84f, 9.88f, 18.4f, 10.0f, 19.0f, 10.0f)
                close()
                moveTo(16.0f, 5.0f)
                curveToRelative(0.0f, 1.66f, 1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.34f, 3.0f, -3.0f)
                reflectiveCurveToRelative(-1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveTo(16.0f, 3.34f, 16.0f, 5.0f)
                close()
            }
        }
        return _markEmailUnread!!
    }

private var _markEmailUnread: ImageVector? = null
