/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.HomeWork: ImageVector
    get() {
        if (_homeWork != null) {
            return _homeWork!!
        }
        _homeWork = materialIcon(name = "Rounded.HomeWork") {
            materialPath {
                moveTo(20.0f, 3.0f)
                horizontalLineToRelative(-8.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(1.61f)
                curveToRelative(0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0.01f)
                lineToRelative(5.0f, 4.5f)
                curveTo(16.64f, 10.68f, 17.0f, 11.5f, 17.0f, 12.35f)
                verticalLineTo(13.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(4.0f)
                curveTo(21.0f, 3.45f, 20.55f, 3.0f, 20.0f, 3.0f)
                close()
                moveTo(15.0f, 7.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(19.0f, 11.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(11.0f)
                close()
                moveTo(19.0f, 7.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(7.0f)
                close()
            }
            materialPath {
                moveTo(15.0f, 20.0f)
                verticalLineToRelative(-7.65f)
                curveToRelative(0.0f, -0.28f, -0.12f, -0.55f, -0.33f, -0.74f)
                lineToRelative(-5.0f, -4.5f)
                curveTo(9.48f, 6.93f, 9.24f, 6.85f, 9.0f, 6.85f)
                curveToRelative(-0.24f, 0.0f, -0.48f, 0.09f, -0.67f, 0.26f)
                lineToRelative(-5.0f, 4.5f)
                curveTo(3.12f, 11.79f, 3.0f, 12.06f, 3.0f, 12.35f)
                verticalLineTo(20.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(2.0f)
                curveTo(14.55f, 21.0f, 15.0f, 20.55f, 15.0f, 20.0f)
                close()
            }
        }
        return _homeWork!!
    }

private var _homeWork: ImageVector? = null
