/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.HdrEnhancedSelect: ImageVector
    get() {
        if (_hdrEnhancedSelect != null) {
            return _hdrEnhancedSelect!!
        }
        _hdrEnhancedSelect = materialIcon(name = "Rounded.HdrEnhancedSelect") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(8.69f, 2.0f, 6.0f, 4.69f, 6.0f, 8.0f)
                reflectiveCurveToRelative(2.69f, 6.0f, 6.0f, 6.0f)
                reflectiveCurveToRelative(6.0f, -2.69f, 6.0f, -6.0f)
                reflectiveCurveTo(15.31f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(14.0f, 9.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(-1.0f)
                curveTo(9.45f, 9.0f, 9.0f, 8.55f, 9.0f, 8.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveTo(15.0f, 8.55f, 14.55f, 9.0f, 14.0f, 9.0f)
                close()
            }
            materialPath {
                moveTo(10.0f, 16.0f)
                horizontalLineTo(7.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, 0.22f, -0.5f, 0.5f)
                verticalLineToRelative(5.0f)
                curveTo(6.5f, 21.78f, 6.72f, 22.0f, 7.0f, 22.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.82f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                verticalLineToRelative(-3.0f)
                curveTo(11.5f, 16.67f, 10.82f, 16.0f, 10.0f, 16.0f)
                close()
                moveTo(10.0f, 20.5f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(20.5f)
                close()
            }
            materialPath {
                moveTo(16.5f, 16.0f)
                horizontalLineTo(14.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.31f)
                curveToRelative(0.0f, 0.38f, 0.31f, 0.69f, 0.69f, 0.69f)
                horizontalLineToRelative(0.11f)
                curveToRelative(0.38f, 0.0f, 0.69f, -0.31f, 0.69f, -0.69f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(1.1f)
                lineToRelative(0.72f, 1.59f)
                curveToRelative(0.11f, 0.25f, 0.36f, 0.41f, 0.63f, 0.41f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.5f, 0.0f, 0.83f, -0.51f, 0.64f, -0.97f)
                lineTo(17.1f, 19.9f)
                curveToRelative(0.5f, -0.3f, 0.9f, -0.8f, 0.9f, -1.4f)
                verticalLineToRelative(-1.0f)
                curveTo(18.0f, 16.67f, 17.33f, 16.0f, 16.5f, 16.0f)
                close()
                moveTo(16.5f, 18.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(18.5f)
                close()
            }
            materialPath {
                moveTo(3.5f, 18.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-1.25f)
                curveTo(1.5f, 16.34f, 1.16f, 16.0f, 0.75f, 16.0f)
                horizontalLineToRelative(0.0f)
                curveTo(0.34f, 16.0f, 0.0f, 16.34f, 0.0f, 16.75f)
                verticalLineToRelative(4.5f)
                curveTo(0.0f, 21.66f, 0.34f, 22.0f, 0.75f, 22.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.41f, 0.0f, 0.75f, -0.34f, 0.75f, -0.75f)
                verticalLineTo(19.5f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(1.75f)
                curveTo(3.5f, 21.66f, 3.84f, 22.0f, 4.25f, 22.0f)
                horizontalLineToRelative(0.0f)
                curveTo(4.66f, 22.0f, 5.0f, 21.66f, 5.0f, 21.25f)
                verticalLineToRelative(-4.5f)
                curveTo(5.0f, 16.34f, 4.66f, 16.0f, 4.25f, 16.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.41f, 0.0f, -0.75f, 0.34f, -0.75f, 0.75f)
                verticalLineTo(18.0f)
                close()
            }
            materialPath {
                moveTo(22.0f, 18.5f)
                verticalLineToRelative(-1.25f)
                curveToRelative(0.0f, -0.41f, -0.34f, -0.75f, -0.75f, -0.75f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.41f, 0.0f, -0.75f, 0.34f, -0.75f, 0.75f)
                verticalLineToRelative(1.25f)
                horizontalLineToRelative(-1.25f)
                curveToRelative(-0.41f, 0.0f, -0.75f, 0.34f, -0.75f, 0.75f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.0f, 0.41f, 0.34f, 0.75f, 0.75f, 0.75f)
                horizontalLineToRelative(1.25f)
                verticalLineToRelative(1.25f)
                curveToRelative(0.0f, 0.41f, 0.34f, 0.75f, 0.75f, 0.75f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.41f, 0.0f, 0.75f, -0.34f, 0.75f, -0.75f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(1.25f)
                curveToRelative(0.41f, 0.0f, 0.75f, -0.34f, 0.75f, -0.75f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.0f, -0.41f, -0.34f, -0.75f, -0.75f, -0.75f)
                horizontalLineTo(22.0f)
                close()
            }
        }
        return _hdrEnhancedSelect!!
    }

private var _hdrEnhancedSelect: ImageVector? = null
