/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.DryCleaning: ImageVector
    get() {
        if (_dryCleaning != null) {
            return _dryCleaning!!
        }
        _dryCleaning = materialIcon(name = "Rounded.DryCleaning") {
            materialPath {
                moveTo(19.56f, 11.36f)
                lineTo(13.0f, 8.44f)
                verticalLineTo(7.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                curveToRelative(0.38f, 0.0f, 0.72f, 0.22f, 0.88f, 0.53f)
                curveTo(13.04f, 4.84f, 13.39f, 5.0f, 13.73f, 5.0f)
                curveToRelative(0.74f, 0.0f, 1.26f, -0.79f, 0.91f, -1.44f)
                curveToRelative(-0.6f, -1.1f, -1.86f, -1.78f, -3.24f, -1.51f)
                curveToRelative(-1.17f, 0.23f, -2.12f, 1.2f, -2.34f, 2.37f)
                curveTo(8.77f, 5.98f, 9.67f, 7.35f, 11.0f, 7.82f)
                verticalLineToRelative(0.63f)
                lineToRelative(-6.56f, 2.92f)
                curveTo(3.56f, 11.75f, 3.0f, 12.62f, 3.0f, 13.57f)
                verticalLineToRelative(0.01f)
                curveTo(3.0f, 14.92f, 4.08f, 16.0f, 5.42f, 16.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(1.58f)
                curveToRelative(1.34f, 0.0f, 2.42f, -1.08f, 2.42f, -2.42f)
                verticalLineToRelative(-0.01f)
                curveTo(21.0f, 12.62f, 20.44f, 11.75f, 19.56f, 11.36f)
                close()
                moveTo(18.58f, 14.0f)
                horizontalLineToRelative(-1.86f)
                curveToRelative(-0.35f, -0.6f, -0.98f, -1.0f, -1.72f, -1.0f)
                horizontalLineTo(9.0f)
                curveToRelative(-0.74f, 0.0f, -1.38f, 0.4f, -1.72f, 1.0f)
                horizontalLineTo(5.42f)
                curveToRelative(-0.46f, 0.0f, -0.58f, -0.65f, -0.17f, -0.81f)
                lineToRelative(6.75f, -3.0f)
                lineToRelative(6.75f, 3.0f)
                curveTo(19.17f, 13.38f, 19.03f, 14.0f, 18.58f, 14.0f)
                close()
            }
        }
        return _dryCleaning!!
    }

private var _dryCleaning: ImageVector? = null
