/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Dry: ImageVector
    get() {
        if (_dry != null) {
            return _dry!!
        }
        _dry = materialIcon(name = "Rounded.Dry") {
            materialPath {
                moveTo(1.94f, 11.79f)
                curveTo(1.34f, 12.36f, 1.0f, 13.14f, 1.0f, 13.97f)
                verticalLineTo(20.0f)
                curveToRelative(0.0f, 1.66f, 1.34f, 3.0f, 3.0f, 3.0f)
                lineToRelative(13.68f, 0.0f)
                curveToRelative(0.65f, 0.0f, 1.25f, -0.47f, 1.32f, -1.12f)
                curveToRelative(0.08f, -0.75f, -0.51f, -1.38f, -1.24f, -1.38f)
                horizontalLineTo(12.5f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                lineToRelative(7.18f, 0.0f)
                curveToRelative(0.65f, 0.0f, 1.25f, -0.47f, 1.32f, -1.12f)
                curveToRelative(0.08f, -0.75f, -0.51f, -1.38f, -1.24f, -1.38f)
                horizontalLineTo(12.5f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                lineToRelative(8.18f, 0.0f)
                curveToRelative(0.65f, 0.0f, 1.25f, -0.47f, 1.32f, -1.12f)
                curveToRelative(0.08f, -0.75f, -0.51f, -1.38f, -1.24f, -1.38f)
                horizontalLineTo(12.5f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                lineToRelative(6.18f, 0.0f)
                curveToRelative(0.65f, 0.0f, 1.25f, -0.47f, 1.32f, -1.12f)
                curveToRelative(0.08f, -0.75f, -0.51f, -1.38f, -1.24f, -1.38f)
                horizontalLineTo(8.86f)
                lineToRelative(1.49f, -2.61f)
                curveToRelative(0.09f, -0.16f, 0.14f, -0.33f, 0.14f, -0.53f)
                curveToRelative(0.0f, -0.26f, -0.09f, -0.5f, -0.26f, -0.7f)
                lineTo(9.81f, 5.71f)
                curveTo(9.43f, 5.32f, 8.8f, 5.3f, 8.4f, 5.68f)
                lineTo(1.94f, 11.79f)
                close()
                moveTo(16.99f, 8.07f)
                curveToRelative(0.0f, 0.52f, -0.42f, 0.93f, -0.93f, 0.93f)
                curveToRelative(-0.52f, 0.0f, -0.93f, -0.42f, -0.93f, -0.93f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.03f, -0.67f, -0.22f, -1.33f, -0.71f, -1.86f)
                lineToRelative(-0.07f, -0.06f)
                curveToRelative(-0.9f, -0.89f, -1.38f, -2.03f, -1.34f, -3.22f)
                lineToRelative(0.0f, 0.0f)
                curveTo(13.0f, 2.42f, 13.42f, 2.0f, 13.93f, 2.0f)
                curveToRelative(0.51f, 0.0f, 0.93f, 0.42f, 0.93f, 0.93f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.03f, 0.67f, 0.22f, 1.33f, 0.71f, 1.86f)
                lineToRelative(0.07f, 0.07f)
                curveTo(16.55f, 5.74f, 17.03f, 6.88f, 16.99f, 8.07f)
                lineTo(16.99f, 8.07f)
                close()
                moveTo(21.0f, 8.07f)
                curveTo(21.0f, 8.58f, 20.58f, 9.0f, 20.06f, 9.0f)
                reflectiveCurveToRelative(-0.93f, -0.42f, -0.93f, -0.93f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.03f, -0.67f, -0.22f, -1.33f, -0.71f, -1.86f)
                lineToRelative(-0.07f, -0.06f)
                curveToRelative(-0.9f, -0.89f, -1.38f, -2.03f, -1.34f, -3.22f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.0f, -0.51f, 0.42f, -0.93f, 0.93f, -0.93f)
                reflectiveCurveToRelative(0.93f, 0.42f, 0.93f, 0.93f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.03f, 0.67f, 0.22f, 1.33f, 0.71f, 1.86f)
                lineToRelative(0.07f, 0.07f)
                curveTo(20.55f, 5.74f, 21.03f, 6.88f, 21.0f, 8.07f)
                lineTo(21.0f, 8.07f)
                close()
            }
        }
        return _dry!!
    }

private var _dry: ImageVector? = null
