/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.DeviceUnknown: ImageVector
    get() {
        if (_deviceUnknown != null) {
            return _deviceUnknown!!
        }
        _deviceUnknown = materialIcon(name = "Rounded.DeviceUnknown") {
            materialPath {
                moveTo(17.0f, 1.0f)
                lineTo(7.0f, 1.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(18.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(19.0f, 3.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(17.0f, 19.0f)
                lineTo(7.0f, 19.0f)
                lineTo(7.0f, 5.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(14.0f)
                close()
                moveTo(11.0f, 16.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
                moveTo(9.52f, 10.19f)
                horizontalLineToRelative(0.13f)
                curveToRelative(0.33f, 0.0f, 0.59f, -0.23f, 0.7f, -0.54f)
                curveToRelative(0.24f, -0.69f, 0.91f, -1.21f, 1.66f, -1.21f)
                curveToRelative(0.93f, 0.0f, 1.75f, 0.82f, 1.75f, 1.75f)
                curveToRelative(0.0f, 1.32f, -1.49f, 1.55f, -2.23f, 2.82f)
                horizontalLineToRelative(-0.01f)
                curveToRelative(-0.08f, 0.14f, -0.14f, 0.29f, -0.2f, 0.45f)
                curveToRelative(-0.01f, 0.02f, -0.02f, 0.03f, -0.02f, 0.05f)
                curveToRelative(-0.01f, 0.02f, -0.01f, 0.04f, -0.01f, 0.05f)
                curveToRelative(-0.1f, 0.31f, -0.16f, 0.66f, -0.16f, 1.08f)
                horizontalLineToRelative(1.76f)
                curveToRelative(0.0f, -0.25f, 0.04f, -0.47f, 0.12f, -0.67f)
                curveToRelative(0.54f, -1.47f, 2.77f, -1.86f, 2.48f, -4.18f)
                curveToRelative(-0.19f, -1.55f, -1.43f, -2.84f, -2.98f, -3.04f)
                curveToRelative(-1.77f, -0.23f, -3.29f, 0.78f, -3.81f, 2.3f)
                curveToRelative(-0.2f, 0.56f, 0.23f, 1.14f, 0.82f, 1.14f)
                close()
            }
        }
        return _deviceUnknown!!
    }

private var _deviceUnknown: ImageVector? = null
