/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Cottage: ImageVector
    get() {
        if (_cottage != null) {
            return _cottage!!
        }
        _cottage = materialIcon(name = "Rounded.Cottage") {
            materialPath {
                moveTo(22.39f, 12.19f)
                curveToRelative(0.34f, -0.44f, 0.25f, -1.07f, -0.19f, -1.4f)
                lineToRelative(-9.6f, -7.33f)
                curveToRelative(-0.36f, -0.27f, -0.86f, -0.27f, -1.21f, 0.0f)
                lineTo(6.0f, 7.58f)
                verticalLineTo(7.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                reflectiveCurveTo(4.0f, 6.45f, 4.0f, 7.0f)
                verticalLineToRelative(2.11f)
                lineToRelative(-2.21f, 1.68f)
                curveToRelative(-0.44f, 0.33f, -0.52f, 0.96f, -0.19f, 1.4f)
                curveToRelative(0.34f, 0.44f, 0.96f, 0.52f, 1.4f, 0.19f)
                lineTo(4.0f, 11.62f)
                verticalLineTo(20.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-5.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-8.38f)
                lineToRelative(0.99f, 0.76f)
                curveTo(21.43f, 12.72f, 22.06f, 12.63f, 22.39f, 12.19f)
                close()
                moveTo(5.27f, 5.0f)
                curveToRelative(-0.74f, 0.0f, -1.26f, -0.8f, -0.9f, -1.45f)
                curveTo(4.89f, 2.62f, 5.87f, 2.0f, 7.0f, 2.0f)
                curveToRelative(0.38f, 0.0f, 0.72f, -0.22f, 0.89f, -0.53f)
                curveTo(8.04f, 1.16f, 8.39f, 1.0f, 8.73f, 1.0f)
                curveToRelative(0.74f, 0.0f, 1.26f, 0.8f, 0.9f, 1.45f)
                curveTo(9.11f, 3.38f, 8.13f, 4.0f, 7.0f, 4.0f)
                curveTo(6.62f, 4.0f, 6.28f, 4.22f, 6.11f, 4.53f)
                curveTo(5.96f, 4.84f, 5.61f, 5.0f, 5.27f, 5.0f)
                close()
            }
        }
        return _cottage!!
    }

private var _cottage: ImageVector? = null
