/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ControlCamera: ImageVector
    get() {
        if (_controlCamera != null) {
            return _controlCamera!!
        }
        _controlCamera = materialIcon(name = "Rounded.ControlCamera") {
            materialPath {
                moveTo(4.65f, 9.35f)
                lineTo(2.7f, 11.3f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(1.95f, 1.95f)
                curveToRelative(0.49f, 0.49f, 1.28f, 0.49f, 1.77f, 0.0f)
                curveToRelative(0.48f, -0.49f, 0.48f, -1.27f, 0.0f, -1.76f)
                lineToRelative(-0.88f, -0.9f)
                lineToRelative(0.88f, -0.89f)
                curveToRelative(0.48f, -0.49f, 0.48f, -1.27f, 0.0f, -1.76f)
                reflectiveCurveToRelative(-1.28f, -0.49f, -1.77f, 0.0f)
                close()
                moveTo(17.58f, 9.35f)
                curveToRelative(-0.48f, 0.49f, -0.48f, 1.27f, 0.0f, 1.76f)
                lineToRelative(0.88f, 0.89f)
                lineToRelative(-0.88f, 0.89f)
                curveToRelative(-0.48f, 0.49f, -0.48f, 1.27f, 0.0f, 1.76f)
                curveToRelative(0.49f, 0.49f, 1.28f, 0.49f, 1.77f, 0.0f)
                lineToRelative(1.95f, -1.95f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(-1.95f, -1.95f)
                curveToRelative(-0.49f, -0.48f, -1.29f, -0.48f, -1.77f, 0.01f)
                close()
                moveTo(12.0f, 18.46f)
                lineToRelative(-0.89f, -0.88f)
                curveToRelative(-0.49f, -0.48f, -1.27f, -0.48f, -1.76f, 0.0f)
                curveToRelative(-0.49f, 0.49f, -0.49f, 1.28f, 0.0f, 1.77f)
                lineToRelative(1.95f, 1.95f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(1.95f, -1.95f)
                curveToRelative(0.49f, -0.49f, 0.49f, -1.28f, 0.0f, -1.77f)
                curveToRelative(-0.49f, -0.48f, -1.27f, -0.48f, -1.76f, 0.0f)
                lineToRelative(-0.9f, 0.88f)
                close()
                moveTo(9.35f, 6.42f)
                curveToRelative(0.49f, 0.48f, 1.27f, 0.48f, 1.76f, 0.0f)
                lineToRelative(0.89f, -0.88f)
                lineToRelative(0.89f, 0.88f)
                curveToRelative(0.49f, 0.48f, 1.27f, 0.48f, 1.76f, 0.0f)
                curveToRelative(0.49f, -0.49f, 0.49f, -1.28f, 0.0f, -1.77f)
                lineTo(12.7f, 2.7f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineTo(9.35f, 4.65f)
                curveToRelative(-0.49f, 0.49f, -0.49f, 1.29f, 0.0f, 1.77f)
                close()
            }
            materialPath {
                moveTo(12.0f, 12.0f)
                moveToRelative(-3.0f, 0.0f)
                arcToRelative(3.0f, 3.0f, 0.0f, true, true, 6.0f, 0.0f)
                arcToRelative(3.0f, 3.0f, 0.0f, true, true, -6.0f, 0.0f)
            }
        }
        return _controlCamera!!
    }

private var _controlCamera: ImageVector? = null
