/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.BookmarkAdded: ImageVector
    get() {
        if (_bookmarkAdded != null) {
            return _bookmarkAdded!!
        }
        _bookmarkAdded = materialIcon(name = "Rounded.BookmarkAdded") {
            materialPath {
                moveTo(5.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                lineToRelative(7.0f, 0.0f)
                curveToRelative(-0.63f, 0.84f, -1.0f, 1.87f, -1.0f, 3.0f)
                curveToRelative(0.0f, 2.76f, 2.24f, 5.0f, 5.0f, 5.0f)
                curveToRelative(0.34f, 0.0f, 0.68f, -0.03f, 1.0f, -0.1f)
                verticalLineToRelative(8.58f)
                curveToRelative(0.0f, 0.72f, -0.73f, 1.2f, -1.39f, 0.92f)
                lineTo(12.0f, 18.0f)
                lineToRelative(-5.61f, 2.4f)
                curveTo(5.73f, 20.69f, 5.0f, 20.2f, 5.0f, 19.48f)
                verticalLineTo(5.0f)
                close()
                moveTo(22.07f, 3.34f)
                curveToRelative(0.39f, 0.39f, 0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(-3.54f, 3.54f)
                curveToRelative(-0.39f, 0.39f, -1.02f, 0.39f, -1.41f, 0.0f)
                lineToRelative(-1.41f, -1.41f)
                curveToRelative(-0.39f, -0.39f, -0.39f, -1.02f, 0.0f, -1.41f)
                curveToRelative(0.39f, -0.39f, 1.02f, -0.39f, 1.41f, 0.0f)
                lineToRelative(0.71f, 0.71f)
                lineToRelative(2.83f, -2.83f)
                curveTo(21.05f, 2.95f, 21.68f, 2.95f, 22.07f, 3.34f)
                close()
            }
        }
        return _bookmarkAdded!!
    }

private var _bookmarkAdded: ImageVector? = null
