/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Bedtime: ImageVector
    get() {
        if (_bedtime != null) {
            return _bedtime!!
        }
        _bedtime = materialIcon(name = "Rounded.Bedtime") {
            materialPath {
                moveTo(11.97f, 2.73f)
                curveToRelative(0.16f, -0.34f, -0.12f, -0.72f, -0.5f, -0.7f)
                curveTo(5.47f, 2.33f, 1.0f, 7.86f, 2.19f, 13.99f)
                curveToRelative(0.78f, 4.03f, 4.09f, 7.22f, 8.14f, 7.87f)
                curveToRelative(4.07f, 0.66f, 7.77f, -1.14f, 9.87f, -4.15f)
                curveToRelative(0.21f, -0.31f, 0.04f, -0.75f, -0.33f, -0.79f)
                curveTo(13.13f, 16.16f, 9.0f, 8.96f, 11.97f, 2.73f)
                close()
            }
        }
        return _bedtime!!
    }

private var _bedtime: ImageVector? = null
