/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.TextRotationAngleup: ImageVector
    get() {
        if (_textRotationAngleup != null) {
            return _textRotationAngleup!!
        }
        _textRotationAngleup = materialIcon(name = "Outlined.TextRotationAngleup") {
            materialPath {
                moveTo(16.76f, 9.0f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(-9.19f, 9.19f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(9.19f, -9.19f)
                lineTo(21.0f, 13.24f)
                lineTo(21.0f, 9.0f)
                horizontalLineToRelative(-4.24f)
                close()
                moveTo(8.48f, 12.75f)
                lineToRelative(3.54f, -3.54f)
                lineToRelative(2.19f, 0.92f)
                lineToRelative(1.48f, -1.48f)
                lineTo(4.56f, 4.23f)
                lineTo(3.5f, 5.29f)
                lineToRelative(4.42f, 11.14f)
                lineToRelative(1.48f, -1.48f)
                lineToRelative(-0.92f, -2.2f)
                close()
                moveTo(7.66f, 11.03f)
                lineTo(5.43f, 6.16f)
                lineToRelative(4.87f, 2.23f)
                lineToRelative(-2.64f, 2.64f)
                close()
            }
        }
        return _textRotationAngleup!!
    }

private var _textRotationAngleup: ImageVector? = null
