/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SubtitlesOff: ImageVector
    get() {
        if (_subtitlesOff != null) {
            return _subtitlesOff!!
        }
        _subtitlesOff = materialIcon(name = "Outlined.SubtitlesOff") {
            materialPath {
                moveTo(20.0f, 4.0f)
                horizontalLineTo(6.83f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(20.0f)
                verticalLineToRelative(11.17f)
                lineToRelative(1.76f, 1.76f)
                curveTo(21.91f, 18.65f, 22.0f, 18.34f, 22.0f, 18.0f)
                verticalLineTo(6.0f)
                curveTo(22.0f, 4.9f, 21.1f, 4.0f, 20.0f, 4.0f)
                close()
            }
            materialPath {
                moveTo(18.0f, 10.0f)
                lineToRelative(-5.17f, 0.0f)
                lineToRelative(2.0f, 2.0f)
                lineToRelative(3.17f, 0.0f)
                close()
            }
            materialPath {
                moveTo(1.04f, 3.87f)
                lineToRelative(1.2f, 1.2f)
                curveTo(2.09f, 5.35f, 2.0f, 5.66f, 2.0f, 6.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(13.17f)
                lineToRelative(2.96f, 2.96f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.45f, 2.45f)
                lineTo(1.04f, 3.87f)
                close()
                moveTo(4.0f, 6.83f)
                lineTo(7.17f, 10.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-1.17f)
                lineTo(11.17f, 14.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(7.17f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(6.83f)
                close()
            }
        }
        return _subtitlesOff!!
    }

private var _subtitlesOff: ImageVector? = null
