/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SignalCellularOff: ImageVector
    get() {
        if (_signalCellularOff != null) {
            return _signalCellularOff!!
        }
        _signalCellularOff = materialIcon(name = "Outlined.SignalCellularOff") {
            materialPath {
                moveTo(21.0f, 1.0f)
                lineToRelative(-8.31f, 8.31f)
                lineToRelative(8.31f, 8.3f)
                close()
                moveTo(4.91f, 4.36f)
                lineTo(3.5f, 5.77f)
                lineToRelative(6.36f, 6.37f)
                lineTo(1.0f, 21.0f)
                horizontalLineToRelative(17.73f)
                lineToRelative(2.0f, 2.0f)
                lineToRelative(1.41f, -1.41f)
                close()
            }
        }
        return _signalCellularOff!!
    }

private var _signalCellularOff: ImageVector? = null
