/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.EditLocation: ImageVector
    get() {
        if (_editLocation != null) {
            return _editLocation!!
        }
        _editLocation = materialIcon(name = "Outlined.EditLocation") {
            materialPath {
                moveTo(18.17f, 4.91f)
                lineTo(17.1f, 3.84f)
                lineToRelative(-5.55f, 5.55f)
                verticalLineToRelative(1.08f)
                horizontalLineToRelative(1.08f)
                lineToRelative(5.54f, -5.56f)
                close()
                moveTo(16.0f, 2.74f)
                lineToRelative(1.29f, -1.29f)
                arcToRelative(1.49f, 1.49f, 0.0f, false, true, 2.12f, 0.0f)
                lineToRelative(1.15f, 1.15f)
                curveToRelative(0.59f, 0.59f, 0.59f, 1.54f, 0.0f, 2.12f)
                lineToRelative(-0.68f, 0.68f)
                lineToRelative(-0.02f, 0.02f)
                lineToRelative(-0.58f, 0.58f)
                lineToRelative(-6.0f, 6.0f)
                lineTo(10.0f, 12.0f)
                lineTo(10.0f, 8.74f)
                lineToRelative(6.0f, -6.0f)
                close()
                moveTo(13.72f, 2.19f)
                lineToRelative(-0.55f, 0.55f)
                lineToRelative(-1.27f, 1.27f)
                curveToRelative(-3.3f, 0.05f, -5.9f, 2.6f, -5.9f, 6.2f)
                curveToRelative(0.0f, 2.34f, 1.95f, 5.44f, 6.0f, 9.14f)
                curveToRelative(4.05f, -3.7f, 6.0f, -6.79f, 6.0f, -9.14f)
                verticalLineToRelative(-0.1f)
                lineToRelative(1.8f, -1.8f)
                curveToRelative(0.13f, 0.6f, 0.2f, 1.24f, 0.2f, 1.9f)
                curveToRelative(0.0f, 3.32f, -2.67f, 7.25f, -8.0f, 11.8f)
                curveToRelative(-5.33f, -4.55f, -8.0f, -8.48f, -8.0f, -11.8f)
                curveToRelative(0.0f, -4.98f, 3.8f, -8.2f, 8.0f, -8.2f)
                curveToRelative(0.58f, 0.0f, 1.16f, 0.06f, 1.72f, 0.18f)
                close()
            }
        }
        return _editLocation!!
    }

private var _editLocation: ImageVector? = null
