/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Cameraswitch: ImageVector
    get() {
        if (_cameraswitch != null) {
            return _cameraswitch!!
        }
        _cameraswitch = materialIcon(name = "Outlined.Cameraswitch") {
            materialPath {
                moveTo(16.0f, 7.0f)
                horizontalLineToRelative(-1.0f)
                lineToRelative(-1.0f, -1.0f)
                horizontalLineToRelative(-4.0f)
                lineTo(9.0f, 7.0f)
                horizontalLineTo(8.0f)
                curveTo(6.9f, 7.0f, 6.0f, 7.9f, 6.0f, 9.0f)
                verticalLineToRelative(6.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(8.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(9.0f)
                curveTo(18.0f, 7.9f, 17.1f, 7.0f, 16.0f, 7.0f)
                close()
                moveTo(16.0f, 15.0f)
                horizontalLineTo(8.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(1.83f)
                lineToRelative(1.0f, -1.0f)
                horizontalLineToRelative(2.34f)
                lineToRelative(1.0f, 1.0f)
                horizontalLineTo(16.0f)
                verticalLineTo(15.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 12.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
            materialPath {
                moveTo(8.57f, 0.52f)
                lineTo(13.05f, 5.0f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(-1.54f, -1.54f)
                curveTo(17.7f, 2.46f, 21.53f, 6.24f, 22.0f, 11.0f)
                horizontalLineToRelative(2.0f)
                curveTo(23.36f, 3.3f, 15.79f, -1.67f, 8.57f, 0.52f)
                close()
            }
            materialPath {
                moveTo(9.54f, 20.41f)
                lineToRelative(1.54f, 1.54f)
                curveTo(6.3f, 21.54f, 2.47f, 17.76f, 2.0f, 13.0f)
                horizontalLineTo(0.0f)
                curveToRelative(0.64f, 7.7f, 8.21f, 12.67f, 15.43f, 10.48f)
                lineTo(10.95f, 19.0f)
                lineTo(9.54f, 20.41f)
                close()
            }
        }
        return _cameraswitch!!
    }

private var _cameraswitch: ImageVector? = null
