/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.BakeryDining: ImageVector
    get() {
        if (_bakeryDining != null) {
            return _bakeryDining!!
        }
        _bakeryDining = materialIcon(name = "Outlined.BakeryDining") {
            materialPath {
                moveTo(20.5f, 10.94f)
                curveToRelative(0.13f, -0.32f, 0.1f, -0.23f, 0.15f, -0.39f)
                curveToRelative(0.3f, -1.21f, -0.34f, -2.47f, -1.5f, -2.93f)
                lineToRelative(-2.01f, -0.8f)
                curveToRelative(-0.46f, -0.18f, -0.95f, -0.21f, -1.41f, -0.12f)
                curveToRelative(-0.11f, -0.33f, -0.29f, -0.63f, -0.52f, -0.89f)
                curveTo(14.73f, 5.29f, 14.06f, 5.0f, 13.36f, 5.0f)
                horizontalLineToRelative(-2.71f)
                curveTo(9.94f, 5.0f, 9.27f, 5.29f, 8.8f, 5.81f)
                curveTo(8.56f, 6.07f, 8.38f, 6.37f, 8.27f, 6.69f)
                curveTo(7.81f, 6.6f, 7.32f, 6.63f, 6.86f, 6.81f)
                lineToRelative(-2.01f, 0.8f)
                curveToRelative(-1.16f, 0.46f, -1.8f, 1.72f, -1.5f, 2.93f)
                lineToRelative(0.15f, 0.38f)
                curveTo(1.1f, 15.55f, 1.0f, 15.55f, 1.0f, 16.38f)
                curveToRelative(0.0f, 0.91f, 0.46f, 1.74f, 1.24f, 2.22f)
                curveToRelative(1.42f, 0.88f, 2.49f, 0.14f, 4.0f, -0.61f)
                horizontalLineToRelative(11.53f)
                curveToRelative(1.52f, 0.76f, 1.86f, 1.01f, 2.63f, 1.01f)
                curveToRelative(1.0f, 0.0f, 2.61f, -0.77f, 2.61f, -2.61f)
                curveTo(23.0f, 15.54f, 22.88f, 15.51f, 20.5f, 10.94f)
                close()
                moveTo(20.12f, 16.93f)
                lineToRelative(-1.68f, -0.84f)
                lineToRelative(1.08f, -2.7f)
                lineToRelative(1.41f, 2.71f)
                curveTo(21.21f, 16.63f, 20.64f, 17.19f, 20.12f, 16.93f)
                close()
                moveTo(15.09f, 15.99f)
                lineToRelative(0.62f, -6.9f)
                curveToRelative(0.03f, -0.33f, 0.37f, -0.54f, 0.68f, -0.42f)
                lineToRelative(2.01f, 0.8f)
                curveToRelative(0.22f, 0.09f, 0.34f, 0.31f, 0.31f, 0.54f)
                lineToRelative(-2.4f, 5.98f)
                horizontalLineTo(15.09f)
                close()
                moveTo(7.68f, 15.99f)
                lineToRelative(-2.4f, -5.98f)
                curveTo(5.25f, 9.78f, 5.37f, 9.56f, 5.59f, 9.47f)
                lineToRelative(2.01f, -0.8f)
                curveToRelative(0.31f, -0.12f, 0.65f, 0.08f, 0.68f, 0.42f)
                lineToRelative(0.62f, 6.9f)
                horizontalLineTo(7.68f)
                close()
                moveTo(3.07f, 16.1f)
                lineToRelative(1.41f, -2.72f)
                lineToRelative(1.08f, 2.71f)
                lineToRelative(-1.68f, 0.84f)
                curveTo(3.36f, 17.19f, 2.79f, 16.63f, 3.07f, 16.1f)
                close()
                moveTo(10.15f, 7.54f)
                curveToRelative(-0.03f, -0.31f, 0.23f, -0.54f, 0.5f, -0.54f)
                horizontalLineToRelative(2.71f)
                curveToRelative(0.27f, 0.0f, 0.53f, 0.23f, 0.5f, 0.54f)
                lineToRelative(-0.77f, 8.45f)
                horizontalLineToRelative(-2.17f)
                lineTo(10.15f, 7.54f)
                close()
            }
        }
        return _bakeryDining!!
    }

private var _bakeryDining: ImageVector? = null
