/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.SwitchRight: ImageVector
    get() {
        if (_switchRight != null) {
            return _switchRight!!
        }
        _switchRight = materialIcon(name = "Filled.SwitchRight") {
            materialPath {
                moveTo(15.5f, 15.38f)
                verticalLineTo(8.62f)
                lineTo(18.88f, 12.0f)
                lineTo(15.5f, 15.38f)
                moveTo(14.0f, 19.0f)
                lineToRelative(7.0f, -7.0f)
                lineToRelative(-7.0f, -7.0f)
                verticalLineTo(19.0f)
                lineTo(14.0f, 19.0f)
                close()
                moveTo(10.0f, 19.0f)
                verticalLineTo(5.0f)
                lineToRelative(-7.0f, 7.0f)
                lineTo(10.0f, 19.0f)
                close()
            }
        }
        return _switchRight!!
    }

private var _switchRight: ImageVector? = null
