/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.SportsMotorsports: ImageVector
    get() {
        if (_sportsMotorsports != null) {
            return _sportsMotorsports!!
        }
        _sportsMotorsports = materialIcon(name = "Filled.SportsMotorsports") {
            materialPath {
                moveTo(12.0f, 11.39f)
                curveToRelative(0.0f, -0.65f, -0.39f, -1.23f, -0.98f, -1.48f)
                lineTo(5.44f, 7.55f)
                curveToRelative(-1.48f, 1.68f, -2.32f, 3.7f, -2.8f, 5.45f)
                horizontalLineToRelative(7.75f)
                curveTo(11.28f, 13.0f, 12.0f, 12.28f, 12.0f, 11.39f)
                close()
            }
            materialPath {
                moveTo(21.96f, 11.22f)
                curveToRelative(-0.41f, -4.41f, -4.56f, -7.49f, -8.98f, -7.2f)
                curveToRelative(-2.51f, 0.16f, -4.44f, 0.94f, -5.93f, 2.04f)
                lineToRelative(4.74f, 2.01f)
                curveToRelative(1.33f, 0.57f, 2.2f, 1.87f, 2.2f, 3.32f)
                curveToRelative(0.0f, 1.99f, -1.62f, 3.61f, -3.61f, 3.61f)
                horizontalLineTo(2.21f)
                curveTo(2.0f, 16.31f, 2.0f, 17.2f, 2.0f, 17.2f)
                verticalLineTo(18.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(10.0f)
                curveTo(18.67f, 20.0f, 22.41f, 15.99f, 21.96f, 11.22f)
                close()
            }
        }
        return _sportsMotorsports!!
    }

private var _sportsMotorsports: ImageVector? = null
