/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.RemoveModerator: ImageVector
    get() {
        if (_removeModerator != null) {
            return _removeModerator!!
        }
        _removeModerator = materialIcon(name = "Filled.RemoveModerator") {
            materialPath {
                moveTo(22.27f, 21.73f)
                lineToRelative(-3.54f, -3.55f)
                lineTo(5.78f, 5.23f)
                lineTo(2.27f, 1.72f)
                lineTo(1.0f, 2.99f)
                lineTo(3.01f, 5.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(6.0f)
                curveToRelative(0.0f, 5.55f, 3.84f, 10.74f, 9.0f, 12.0f)
                curveToRelative(2.16f, -0.53f, 4.08f, -1.76f, 5.6f, -3.41f)
                lineTo(21.0f, 23.0f)
                lineToRelative(1.27f, -1.27f)
                close()
                moveTo(13.0f, 9.92f)
                lineToRelative(6.67f, 6.67f)
                curveTo(20.51f, 14.87f, 21.0f, 12.96f, 21.0f, 11.0f)
                verticalLineTo(5.0f)
                lineToRelative(-9.0f, -4.0f)
                lineToRelative(-5.48f, 2.44f)
                lineTo(11.0f, 7.92f)
                lineToRelative(2.0f, 2.0f)
                close()
            }
        }
        return _removeModerator!!
    }

private var _removeModerator: ImageVector? = null
