/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.PlayDisabled: ImageVector
    get() {
        if (_playDisabled != null) {
            return _playDisabled!!
        }
        _playDisabled = materialIcon(name = "Filled.PlayDisabled") {
            materialPath {
                moveTo(8.0f, 5.19f)
                lineTo(8.0f, 5.0f)
                lineToRelative(11.0f, 7.0f)
                lineToRelative(-2.55f, 1.63f)
                lineTo(8.0f, 5.19f)
                close()
                moveTo(20.0f, 19.73f)
                lineToRelative(-5.11f, -5.11f)
                lineTo(8.0f, 7.73f)
                lineTo(4.27f, 4.0f)
                lineTo(3.0f, 5.27f)
                lineToRelative(5.0f, 5.0f)
                lineTo(8.0f, 19.0f)
                lineToRelative(5.33f, -3.4f)
                lineToRelative(5.4f, 5.4f)
                lineTo(20.0f, 19.73f)
                close()
            }
        }
        return _playDisabled!!
    }

private var _playDisabled: ImageVector? = null
