/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.NoAccounts: ImageVector
    get() {
        if (_noAccounts != null) {
            return _noAccounts!!
        }
        _noAccounts = materialIcon(name = "Filled.NoAccounts") {
            materialPath {
                moveTo(15.18f, 10.94f)
                curveToRelative(0.2f, -0.44f, 0.32f, -0.92f, 0.32f, -1.44f)
                curveTo(15.5f, 7.57f, 13.93f, 6.0f, 12.0f, 6.0f)
                curveToRelative(-0.52f, 0.0f, -1.0f, 0.12f, -1.44f, 0.32f)
                lineTo(15.18f, 10.94f)
                close()
            }
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                reflectiveCurveTo(17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(12.0f, 15.0f)
                curveToRelative(-2.32f, 0.0f, -4.45f, 0.8f, -6.14f, 2.12f)
                curveTo(4.7f, 15.73f, 4.0f, 13.95f, 4.0f, 12.0f)
                curveToRelative(0.0f, -1.85f, 0.63f, -3.55f, 1.69f, -4.9f)
                lineToRelative(2.86f, 2.86f)
                curveToRelative(0.21f, 1.56f, 1.43f, 2.79f, 2.99f, 2.99f)
                lineToRelative(2.2f, 2.2f)
                curveTo(13.17f, 15.05f, 12.59f, 15.0f, 12.0f, 15.0f)
                close()
                moveTo(18.31f, 16.9f)
                lineTo(7.1f, 5.69f)
                curveTo(8.45f, 4.63f, 10.15f, 4.0f, 12.0f, 4.0f)
                curveToRelative(4.42f, 0.0f, 8.0f, 3.58f, 8.0f, 8.0f)
                curveTo(20.0f, 13.85f, 19.37f, 15.54f, 18.31f, 16.9f)
                close()
            }
        }
        return _noAccounts!!
    }

private var _noAccounts: ImageVector? = null
