/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.FaceRetouchingNatural: ImageVector
    get() {
        if (_faceRetouchingNatural != null) {
            return _faceRetouchingNatural!!
        }
        _faceRetouchingNatural = materialIcon(name = "Filled.FaceRetouchingNatural") {
            materialPath {
                moveTo(9.0f, 13.0f)
                moveToRelative(-1.25f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, 2.5f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, -2.5f, 0.0f)
            }
            materialPath {
                moveTo(20.77f, 8.58f)
                lineToRelative(-0.92f, 2.01f)
                curveToRelative(0.09f, 0.46f, 0.15f, 0.93f, 0.15f, 1.41f)
                curveToRelative(0.0f, 4.41f, -3.59f, 8.0f, -8.0f, 8.0f)
                reflectiveCurveToRelative(-8.0f, -3.59f, -8.0f, -8.0f)
                curveToRelative(0.0f, -0.05f, 0.01f, -0.1f, 0.0f, -0.14f)
                curveToRelative(2.6f, -0.98f, 4.69f, -2.99f, 5.74f, -5.55f)
                curveTo(11.58f, 8.56f, 14.37f, 10.0f, 17.5f, 10.0f)
                curveToRelative(0.45f, 0.0f, 0.89f, -0.04f, 1.33f, -0.1f)
                lineToRelative(-0.6f, -1.32f)
                lineToRelative(-0.88f, -1.93f)
                lineToRelative(-1.93f, -0.88f)
                lineToRelative(-2.79f, -1.27f)
                lineToRelative(2.79f, -1.27f)
                lineToRelative(0.71f, -0.32f)
                curveTo(14.87f, 2.33f, 13.47f, 2.0f, 12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                curveToRelative(0.0f, -1.47f, -0.33f, -2.87f, -0.9f, -4.13f)
                lineToRelative(-0.33f, 0.71f)
                close()
            }
            materialPath {
                moveTo(15.0f, 13.0f)
                moveToRelative(-1.25f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, 2.5f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, -2.5f, 0.0f)
            }
            materialPath {
                moveTo(20.6f, 5.6f)
                lineTo(19.5f, 8.0f)
                lineToRelative(-1.1f, -2.4f)
                lineTo(16.0f, 4.5f)
                lineToRelative(2.4f, -1.1f)
                lineTo(19.5f, 1.0f)
                lineToRelative(1.1f, 2.4f)
                lineTo(23.0f, 4.5f)
                close()
            }
        }
        return _faceRetouchingNatural!!
    }

private var _faceRetouchingNatural: ImageVector? = null
