/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.EditLocation: ImageVector
    get() {
        if (_editLocation != null) {
            return _editLocation!!
        }
        _editLocation = materialIcon(name = "Filled.EditLocation") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(8.14f, 2.0f, 5.0f, 5.14f, 5.0f, 9.0f)
                curveToRelative(0.0f, 5.25f, 7.0f, 13.0f, 7.0f, 13.0f)
                reflectiveCurveToRelative(7.0f, -7.75f, 7.0f, -13.0f)
                curveToRelative(0.0f, -3.86f, -3.14f, -7.0f, -7.0f, -7.0f)
                close()
                moveTo(10.44f, 12.0f)
                lineTo(9.0f, 12.0f)
                verticalLineToRelative(-1.44f)
                lineToRelative(3.35f, -3.34f)
                lineToRelative(1.43f, 1.43f)
                lineTo(10.44f, 12.0f)
                close()
                moveTo(14.89f, 7.55f)
                lineToRelative(-0.7f, 0.7f)
                lineToRelative(-1.44f, -1.44f)
                lineToRelative(0.7f, -0.7f)
                curveToRelative(0.15f, -0.15f, 0.39f, -0.15f, 0.54f, 0.0f)
                lineToRelative(0.9f, 0.9f)
                curveToRelative(0.15f, 0.15f, 0.15f, 0.39f, 0.0f, 0.54f)
                close()
            }
        }
        return _editLocation!!
    }

private var _editLocation: ImageVector? = null
