/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.TwoTone.VolumeMute",
    ReplaceWith( "Icons.AutoMirrored.TwoTone.VolumeMute",
            "androidx.compose.material.icons.automirrored.twotone.VolumeMute"),
)
public val Icons.TwoTone.VolumeMute: ImageVector
    get() {
        if (_volumeMute != null) {
            return _volumeMute!!
        }
        _volumeMute = materialIcon(name = "TwoTone.VolumeMute") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(9.0f, 13.0f)
                horizontalLineToRelative(2.83f)
                lineTo(14.0f, 15.17f)
                verticalLineTo(8.83f)
                lineTo(11.83f, 11.0f)
                horizontalLineTo(9.0f)
                close()
            }
            materialPath {
                moveTo(7.0f, 9.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(4.0f)
                lineToRelative(5.0f, 5.0f)
                lineTo(16.0f, 4.0f)
                lineToRelative(-5.0f, 5.0f)
                lineTo(7.0f, 9.0f)
                close()
                moveTo(14.0f, 8.83f)
                verticalLineToRelative(6.34f)
                lineTo(11.83f, 13.0f)
                lineTo(9.0f, 13.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.83f)
                lineTo(14.0f, 8.83f)
                close()
            }
        }
        return _volumeMute!!
    }

private var _volumeMute: ImageVector? = null
