/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.HomeMini: ImageVector
    get() {
        if (_homeMini != null) {
            return _homeMini!!
        }
        _homeMini = materialIcon(name = "Sharp.HomeMini") {
            materialPath {
                moveTo(12.0f, 5.0f)
                curveTo(4.19f, 5.0f, 2.0f, 9.48f, 2.0f, 12.0f)
                curveToRelative(0.0f, 3.86f, 3.13f, 7.0f, 6.99f, 7.0f)
                horizontalLineToRelative(6.02f)
                curveToRelative(2.69f, 0.0f, 6.99f, -2.08f, 6.99f, -7.0f)
                curveTo(22.0f, 12.0f, 22.0f, 5.0f, 12.0f, 5.0f)
                close()
                moveTo(12.0f, 7.0f)
                curveToRelative(7.64f, 0.0f, 7.99f, 4.51f, 8.0f, 5.0f)
                horizontalLineTo(4.0f)
                curveTo(4.0f, 11.8f, 4.09f, 7.0f, 12.0f, 7.0f)
                close()
                moveTo(14.86f, 17.0f)
                horizontalLineTo(9.14f)
                curveToRelative(-2.1f, 0.0f, -3.92f, -1.24f, -4.71f, -3.0f)
                horizontalLineToRelative(15.15f)
                curveTo(18.78f, 15.76f, 16.96f, 17.0f, 14.86f, 17.0f)
                close()
            }
        }
        return _homeMini!!
    }

private var _homeMini: ImageVector? = null
