/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Fastfood: ImageVector
    get() {
        if (_fastfood != null) {
            return _fastfood!!
        }
        _fastfood = materialIcon(name = "Sharp.Fastfood") {
            materialPath {
                moveTo(18.0f, 5.0f)
                verticalLineTo(1.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-5.0f)
                lineToRelative(0.23f, 2.31f)
                curveTo(14.9f, 8.16f, 18.0f, 10.77f, 18.0f, 15.0f)
                lineToRelative(0.02f, 8.0f)
                horizontalLineToRelative(3.18f)
                lineTo(23.0f, 5.0f)
                horizontalLineToRelative(-5.0f)
                close()
                moveTo(1.0f, 21.0f)
                horizontalLineToRelative(15.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(1.0f)
                close()
                moveTo(8.5f, 8.99f)
                curveTo(4.75f, 8.99f, 1.0f, 11.0f, 1.0f, 15.0f)
                horizontalLineToRelative(15.0f)
                curveToRelative(0.0f, -4.0f, -3.75f, -6.01f, -7.5f, -6.01f)
                close()
                moveTo(1.0f, 17.0f)
                horizontalLineToRelative(15.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(1.0f)
                close()
            }
        }
        return _fastfood!!
    }

private var _fastfood: ImageVector? = null
