/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Beenhere: ImageVector
    get() {
        if (_beenhere != null) {
            return _beenhere!!
        }
        _beenhere = materialIcon(name = "Sharp.Beenhere") {
            materialPath {
                moveTo(3.01f, 1.0f)
                lineTo(3.0f, 17.0f)
                lineToRelative(9.0f, 6.0f)
                lineToRelative(8.99f, -6.0f)
                lineTo(21.0f, 1.0f)
                horizontalLineTo(3.01f)
                close()
                moveTo(10.0f, 16.0f)
                lineToRelative(-5.0f, -5.0f)
                lineToRelative(1.41f, -1.42f)
                lineTo(10.0f, 13.17f)
                lineToRelative(7.59f, -7.59f)
                lineTo(19.0f, 7.0f)
                lineToRelative(-9.0f, 9.0f)
                close()
            }
        }
        return _beenhere!!
    }

private var _beenhere: ImageVector? = null
