/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.AddAlert: ImageVector
    get() {
        if (_addAlert != null) {
            return _addAlert!!
        }
        _addAlert = materialIcon(name = "Sharp.AddAlert") {
            materialPath {
                moveTo(12.0f, 23.0f)
                curveToRelative(1.1f, 0.0f, 1.99f, -0.89f, 1.99f, -1.99f)
                horizontalLineToRelative(-3.98f)
                curveToRelative(0.0f, 1.1f, 0.89f, 1.99f, 1.99f, 1.99f)
                close()
                moveTo(19.0f, 17.0f)
                verticalLineToRelative(-6.0f)
                curveToRelative(0.0f, -3.35f, -2.36f, -6.15f, -5.5f, -6.83f)
                lineTo(13.5f, 1.5f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(2.67f)
                curveTo(7.36f, 4.85f, 5.0f, 7.65f, 5.0f, 11.0f)
                verticalLineToRelative(6.0f)
                lineToRelative(-2.0f, 2.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(18.0f)
                verticalLineToRelative(-1.0f)
                lineToRelative(-2.0f, -2.0f)
                close()
                moveTo(16.0f, 13.01f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-3.0f)
                lineTo(8.0f, 13.01f)
                lineTo(8.0f, 11.0f)
                horizontalLineToRelative(3.0f)
                lineTo(11.0f, 8.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(2.01f)
                close()
            }
        }
        return _addAlert!!
    }

private var _addAlert: ImageVector? = null
