/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ZoomOutMap: ImageVector
    get() {
        if (_zoomOutMap != null) {
            return _zoomOutMap!!
        }
        _zoomOutMap = materialIcon(name = "Rounded.ZoomOutMap") {
            materialPath {
                moveTo(15.85f, 3.85f)
                lineTo(17.3f, 5.3f)
                lineToRelative(-2.18f, 2.16f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.03f, 0.0f, 1.42f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, 0.39f, 1.03f, 0.39f, 1.42f, 0.0f)
                lineTo(18.7f, 6.7f)
                lineToRelative(1.45f, 1.45f)
                curveTo(20.46f, 8.46f, 21.0f, 8.24f, 21.0f, 7.79f)
                verticalLineTo(3.5f)
                curveTo(21.0f, 3.22f, 20.78f, 3.0f, 20.5f, 3.0f)
                horizontalLineToRelative(-4.29f)
                curveTo(15.76f, 3.0f, 15.54f, 3.54f, 15.85f, 3.85f)
                close()
                moveTo(3.85f, 8.15f)
                lineTo(5.3f, 6.7f)
                lineToRelative(2.16f, 2.18f)
                curveToRelative(0.39f, 0.39f, 1.03f, 0.39f, 1.42f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.03f, 0.0f, -1.42f)
                lineTo(6.7f, 5.3f)
                lineToRelative(1.45f, -1.45f)
                curveTo(8.46f, 3.54f, 8.24f, 3.0f, 7.79f, 3.0f)
                horizontalLineTo(3.5f)
                curveTo(3.22f, 3.0f, 3.0f, 3.22f, 3.0f, 3.5f)
                verticalLineToRelative(4.29f)
                curveTo(3.0f, 8.24f, 3.54f, 8.46f, 3.85f, 8.15f)
                close()
                moveTo(8.15f, 20.15f)
                lineTo(6.7f, 18.7f)
                lineToRelative(2.18f, -2.16f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.03f, 0.0f, -1.42f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.39f, -0.39f, -1.03f, -0.39f, -1.42f, 0.0f)
                lineTo(5.3f, 17.3f)
                lineToRelative(-1.45f, -1.45f)
                curveTo(3.54f, 15.54f, 3.0f, 15.76f, 3.0f, 16.21f)
                verticalLineToRelative(4.29f)
                curveTo(3.0f, 20.78f, 3.22f, 21.0f, 3.5f, 21.0f)
                horizontalLineToRelative(4.29f)
                curveTo(8.24f, 21.0f, 8.46f, 20.46f, 8.15f, 20.15f)
                close()
                moveTo(20.15f, 15.85f)
                lineTo(18.7f, 17.3f)
                lineToRelative(-2.16f, -2.18f)
                curveToRelative(-0.39f, -0.39f, -1.03f, -0.39f, -1.42f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.03f, 0.0f, 1.42f)
                lineToRelative(2.18f, 2.16f)
                lineToRelative(-1.45f, 1.45f)
                curveTo(15.54f, 20.46f, 15.76f, 21.0f, 16.21f, 21.0f)
                horizontalLineToRelative(4.29f)
                curveToRelative(0.28f, 0.0f, 0.5f, -0.22f, 0.5f, -0.5f)
                verticalLineToRelative(-4.29f)
                curveTo(21.0f, 15.76f, 20.46f, 15.54f, 20.15f, 15.85f)
                close()
            }
        }
        return _zoomOutMap!!
    }

private var _zoomOutMap: ImageVector? = null
