/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.NoiseControlOff: ImageVector
    get() {
        if (_noiseControlOff != null) {
            return _noiseControlOff!!
        }
        _noiseControlOff = materialIcon(name = "Rounded.NoiseControlOff") {
            materialPath {
                moveTo(12.0f, 4.0f)
                curveToRelative(1.2f, 0.0f, 2.33f, 0.26f, 3.35f, 0.74f)
                curveToRelative(0.36f, 0.17f, 0.79f, 0.12f, 1.07f, -0.17f)
                lineToRelative(0.06f, -0.06f)
                curveToRelative(0.47f, -0.47f, 0.35f, -1.29f, -0.25f, -1.57f)
                curveTo(14.95f, 2.34f, 13.51f, 2.0f, 12.0f, 2.0f)
                reflectiveCurveTo(9.05f, 2.34f, 7.76f, 2.94f)
                curveToRelative(-0.6f, 0.28f, -0.72f, 1.1f, -0.25f, 1.57f)
                lineToRelative(0.06f, 0.06f)
                curveToRelative(0.28f, 0.28f, 0.71f, 0.34f, 1.07f, 0.17f)
                curveTo(9.67f, 4.26f, 10.8f, 4.0f, 12.0f, 4.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 12.0f)
                curveToRelative(0.0f, 1.2f, -0.26f, 2.33f, -0.74f, 3.35f)
                curveToRelative(-0.17f, 0.36f, -0.12f, 0.79f, 0.17f, 1.07f)
                lineToRelative(0.06f, 0.06f)
                curveToRelative(0.47f, 0.47f, 1.29f, 0.35f, 1.57f, -0.25f)
                curveTo(21.66f, 14.95f, 22.0f, 13.51f, 22.0f, 12.0f)
                reflectiveCurveToRelative(-0.34f, -2.95f, -0.94f, -4.24f)
                curveToRelative(-0.28f, -0.6f, -1.1f, -0.72f, -1.57f, -0.25f)
                lineToRelative(-0.06f, 0.06f)
                curveToRelative(-0.28f, 0.28f, -0.34f, 0.71f, -0.17f, 1.07f)
                curveTo(19.74f, 9.67f, 20.0f, 10.8f, 20.0f, 12.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 20.0f)
                curveToRelative(-1.2f, 0.0f, -2.33f, -0.26f, -3.35f, -0.74f)
                curveToRelative(-0.36f, -0.17f, -0.79f, -0.12f, -1.07f, 0.17f)
                lineToRelative(-0.06f, 0.06f)
                curveToRelative(-0.47f, 0.47f, -0.35f, 1.29f, 0.25f, 1.57f)
                curveTo(9.05f, 21.66f, 10.49f, 22.0f, 12.0f, 22.0f)
                reflectiveCurveToRelative(2.95f, -0.34f, 4.24f, -0.94f)
                curveToRelative(0.6f, -0.28f, 0.72f, -1.1f, 0.25f, -1.57f)
                lineToRelative(-0.06f, -0.06f)
                curveToRelative(-0.28f, -0.28f, -0.71f, -0.34f, -1.07f, -0.17f)
                curveTo(14.33f, 19.74f, 13.2f, 20.0f, 12.0f, 20.0f)
                close()
            }
            materialPath {
                moveTo(4.0f, 12.0f)
                curveToRelative(0.0f, -1.2f, 0.26f, -2.33f, 0.74f, -3.35f)
                curveToRelative(0.17f, -0.36f, 0.12f, -0.79f, -0.17f, -1.07f)
                lineTo(4.51f, 7.51f)
                curveTo(4.04f, 7.04f, 3.23f, 7.16f, 2.94f, 7.76f)
                curveTo(2.34f, 9.05f, 2.0f, 10.49f, 2.0f, 12.0f)
                reflectiveCurveToRelative(0.34f, 2.95f, 0.94f, 4.24f)
                curveToRelative(0.28f, 0.6f, 1.1f, 0.72f, 1.57f, 0.25f)
                lineToRelative(0.06f, -0.06f)
                curveToRelative(0.28f, -0.28f, 0.34f, -0.71f, 0.17f, -1.07f)
                curveTo(4.26f, 14.33f, 4.0f, 13.2f, 4.0f, 12.0f)
                close()
            }
            materialPath {
                moveTo(11.5f, 6.0f)
                curveToRelative(-2.89f, 0.0f, -5.15f, 2.74f, -4.33f, 5.76f)
                curveToRelative(0.22f, 0.8f, 0.68f, 1.51f, 1.27f, 2.1f)
                lineToRelative(1.27f, 1.27f)
                curveToRelative(0.15f, 0.16f, 0.28f, 0.38f, 0.4f, 0.71f)
                curveToRelative(0.41f, 1.13f, 1.38f, 2.04f, 2.58f, 2.16f)
                curveToRelative(1.25f, 0.12f, 2.37f, -0.53f, 2.93f, -1.53f)
                curveToRelative(0.36f, -0.65f, -0.15f, -1.45f, -0.9f, -1.45f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.34f, 0.0f, -0.68f, 0.16f, -0.84f, 0.47f)
                curveTo(13.72f, 15.78f, 13.38f, 16.0f, 13.0f, 16.0f)
                curveToRelative(-0.43f, 0.0f, -0.81f, -0.27f, -0.95f, -0.68f)
                curveToRelative(-0.15f, -0.44f, -0.4f, -1.08f, -0.93f, -1.61f)
                lineToRelative(-1.36f, -1.36f)
                curveTo(9.28f, 11.87f, 9.0f, 11.19f, 9.0f, 10.5f)
                curveTo(9.0f, 9.12f, 10.12f, 8.0f, 11.5f, 8.0f)
                curveToRelative(0.98f, 0.0f, 1.83f, 0.57f, 2.24f, 1.4f)
                curveToRelative(0.18f, 0.36f, 0.52f, 0.6f, 0.91f, 0.6f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.75f, 0.0f, 1.22f, -0.79f, 0.89f, -1.46f)
                curveTo(14.82f, 7.04f, 13.28f, 6.0f, 11.5f, 6.0f)
                close()
            }
            materialPath {
                moveTo(13.5f, 12.5f)
                moveToRelative(-1.5f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, 3.0f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, -3.0f, 0.0f)
            }
        }
        return _noiseControlOff!!
    }

private var _noiseControlOff: ImageVector? = null
