/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Hevc: ImageVector
    get() {
        if (_hevc != null) {
            return _hevc!!
        }
        _hevc = materialIcon(name = "Rounded.Hevc") {
            materialPath {
                moveTo(6.25f, 9.0f)
                curveTo(5.84f, 9.0f, 5.5f, 9.34f, 5.5f, 9.75f)
                verticalLineTo(11.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(9.75f)
                curveTo(4.5f, 9.34f, 4.16f, 9.0f, 3.75f, 9.0f)
                reflectiveCurveTo(3.0f, 9.34f, 3.0f, 9.75f)
                verticalLineToRelative(4.5f)
                curveTo(3.0f, 14.66f, 3.34f, 15.0f, 3.75f, 15.0f)
                reflectiveCurveToRelative(0.75f, -0.34f, 0.75f, -0.75f)
                verticalLineTo(12.5f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.75f)
                curveTo(5.5f, 14.66f, 5.84f, 15.0f, 6.25f, 15.0f)
                reflectiveCurveTo(7.0f, 14.66f, 7.0f, 14.25f)
                verticalLineToRelative(-4.5f)
                curveTo(7.0f, 9.34f, 6.66f, 9.0f, 6.25f, 9.0f)
                close()
            }
            materialPath {
                moveTo(10.75f, 10.5f)
                curveToRelative(0.41f, 0.0f, 0.75f, -0.34f, 0.75f, -0.75f)
                curveTo(11.5f, 9.34f, 11.16f, 9.0f, 10.75f, 9.0f)
                horizontalLineTo(9.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(1.75f)
                curveToRelative(0.41f, 0.0f, 0.75f, -0.34f, 0.75f, -0.75f)
                curveToRelative(0.0f, -0.41f, -0.34f, -0.75f, -0.75f, -0.75f)
                horizontalLineTo(9.5f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(1.25f)
                curveToRelative(0.41f, 0.0f, 0.75f, -0.34f, 0.75f, -0.75f)
                curveToRelative(0.0f, -0.41f, -0.34f, -0.75f, -0.75f, -0.75f)
                horizontalLineTo(9.5f)
                verticalLineToRelative(-0.5f)
                horizontalLineTo(10.75f)
                close()
            }
            materialPath {
                moveTo(15.63f, 9.0f)
                curveToRelative(-0.36f, 0.0f, -0.67f, 0.26f, -0.73f, 0.62f)
                lineToRelative(-0.65f, 3.88f)
                lineTo(13.6f, 9.62f)
                curveTo(13.54f, 9.26f, 13.23f, 9.0f, 12.87f, 9.0f)
                curveToRelative(-0.46f, 0.0f, -0.8f, 0.41f, -0.73f, 0.86f)
                lineToRelative(0.65f, 3.91f)
                curveToRelative(0.12f, 0.71f, 0.73f, 1.23f, 1.46f, 1.23f)
                reflectiveCurveToRelative(1.34f, -0.52f, 1.46f, -1.23f)
                lineToRelative(0.65f, -3.91f)
                curveTo(16.43f, 9.41f, 16.08f, 9.0f, 15.63f, 9.0f)
                close()
            }
            materialPath {
                moveTo(19.5f, 10.5f)
                curveToRelative(0.0f, 0.28f, 0.22f, 0.5f, 0.5f, 0.5f)
                horizontalLineToRelative(0.5f)
                curveToRelative(0.28f, 0.0f, 0.5f, -0.22f, 0.5f, -0.5f)
                verticalLineTo(10.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-0.5f)
                curveToRelative(0.0f, -0.28f, -0.22f, -0.5f, -0.5f, -0.5f)
                horizontalLineTo(20.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, 0.22f, -0.5f, 0.5f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineTo(19.5f)
                close()
            }
        }
        return _hevc!!
    }

private var _hevc: ImageVector? = null
