/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.HdrOffSelect: ImageVector
    get() {
        if (_hdrOffSelect != null) {
            return _hdrOffSelect!!
        }
        _hdrOffSelect = materialIcon(name = "Rounded.HdrOffSelect") {
            materialPath {
                moveTo(18.0f, 18.5f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -0.83f, -0.67f, -1.5f, -1.5f, -1.5f)
                horizontalLineTo(14.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.31f)
                curveToRelative(0.0f, 0.38f, 0.31f, 0.69f, 0.69f, 0.69f)
                horizontalLineToRelative(0.11f)
                curveToRelative(0.38f, 0.0f, 0.69f, -0.31f, 0.69f, -0.69f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(1.1f)
                lineToRelative(0.72f, 1.59f)
                curveToRelative(0.11f, 0.25f, 0.36f, 0.41f, 0.63f, 0.41f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.5f, 0.0f, 0.83f, -0.51f, 0.64f, -0.97f)
                lineTo(17.1f, 19.9f)
                curveTo(17.6f, 19.6f, 18.0f, 19.1f, 18.0f, 18.5f)
                close()
                moveTo(16.5f, 18.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(18.5f)
                close()
                moveTo(3.5f, 18.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-1.25f)
                curveTo(1.5f, 16.34f, 1.16f, 16.0f, 0.75f, 16.0f)
                horizontalLineToRelative(0.0f)
                curveTo(0.34f, 16.0f, 0.0f, 16.34f, 0.0f, 16.75f)
                verticalLineToRelative(4.5f)
                curveTo(0.0f, 21.66f, 0.34f, 22.0f, 0.75f, 22.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.41f, 0.0f, 0.75f, -0.34f, 0.75f, -0.75f)
                verticalLineTo(19.5f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(1.75f)
                curveTo(3.5f, 21.66f, 3.84f, 22.0f, 4.25f, 22.0f)
                horizontalLineToRelative(0.0f)
                curveTo(4.66f, 22.0f, 5.0f, 21.66f, 5.0f, 21.25f)
                verticalLineToRelative(-4.5f)
                curveTo(5.0f, 16.34f, 4.66f, 16.0f, 4.25f, 16.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.41f, 0.0f, -0.75f, 0.34f, -0.75f, 0.75f)
                verticalLineTo(18.0f)
                close()
                moveTo(10.0f, 16.0f)
                horizontalLineTo(7.5f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineTo(10.0f)
                curveToRelative(0.82f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                verticalLineToRelative(-3.0f)
                curveTo(11.5f, 16.67f, 10.82f, 16.0f, 10.0f, 16.0f)
                close()
                moveTo(10.0f, 20.5f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(20.5f)
                close()
                moveTo(23.25f, 20.0f)
                horizontalLineTo(22.0f)
                verticalLineToRelative(1.25f)
                curveToRelative(0.0f, 0.41f, -0.34f, 0.75f, -0.75f, 0.75f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.41f, 0.0f, -0.75f, -0.34f, -0.75f, -0.75f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(-1.25f)
                curveToRelative(-0.41f, 0.0f, -0.75f, -0.34f, -0.75f, -0.75f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.0f, -0.41f, 0.34f, -0.75f, 0.75f, -0.75f)
                horizontalLineToRelative(1.25f)
                verticalLineToRelative(-1.25f)
                curveToRelative(0.0f, -0.41f, 0.34f, -0.75f, 0.75f, -0.75f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.41f, 0.0f, 0.75f, 0.34f, 0.75f, 0.75f)
                verticalLineToRelative(1.25f)
                horizontalLineToRelative(1.25f)
                curveToRelative(0.41f, 0.0f, 0.75f, 0.34f, 0.75f, 0.75f)
                lineToRelative(0.0f, 0.0f)
                curveTo(24.0f, 19.66f, 23.66f, 20.0f, 23.25f, 20.0f)
                close()
                moveTo(10.98f, 4.15f)
                lineTo(9.42f, 2.59f)
                curveToRelative(5.1f, -2.42f, 10.41f, 2.89f, 7.99f, 7.99f)
                lineToRelative(-1.56f, -1.56f)
                curveTo(16.66f, 6.06f, 13.94f, 3.34f, 10.98f, 4.15f)
                close()
                moveTo(5.63f, 3.05f)
                lineTo(5.63f, 3.05f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(0.96f, 0.96f)
                curveToRelative(-2.42f, 5.1f, 2.88f, 10.41f, 7.99f, 7.99f)
                lineToRelative(0.95f, 0.95f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(-9.9f, -9.91f)
                curveTo(6.66f, 2.66f, 6.02f, 2.66f, 5.63f, 3.05f)
                close()
                moveTo(8.15f, 6.98f)
                lineToRelative(4.87f, 4.87f)
                curveTo(10.06f, 12.66f, 7.34f, 9.94f, 8.15f, 6.98f)
                close()
            }
        }
        return _hdrOffSelect!!
    }

private var _hdrOffSelect: ImageVector? = null
