/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.Rounded.FormatTextdirectionRToL",
    ReplaceWith( "Icons.AutoMirrored.Rounded.FormatTextdirectionRToL",
            "androidx.compose.material.icons.automirrored.rounded.FormatTextdirectionRToL"),
)
public val Icons.Rounded.FormatTextdirectionRToL: ImageVector
    get() {
        if (_formatTextdirectionRToL != null) {
            return _formatTextdirectionRToL!!
        }
        _formatTextdirectionRToL = materialIcon(name = "Rounded.FormatTextdirectionRToL") {
            materialPath {
                moveTo(10.0f, 10.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                lineTo(12.0f, 4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(10.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                lineTo(16.0f, 4.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                reflectiveCurveToRelative(-0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-6.83f)
                curveTo(8.08f, 2.0f, 6.22f, 3.53f, 6.02f, 5.61f)
                curveTo(5.79f, 7.99f, 7.66f, 10.0f, 10.0f, 10.0f)
                close()
                moveTo(8.0f, 17.0f)
                verticalLineToRelative(-1.79f)
                curveToRelative(0.0f, -0.45f, -0.54f, -0.67f, -0.85f, -0.35f)
                lineToRelative(-2.79f, 2.79f)
                curveToRelative(-0.2f, 0.2f, -0.2f, 0.51f, 0.0f, 0.71f)
                lineToRelative(2.79f, 2.79f)
                curveToRelative(0.31f, 0.31f, 0.85f, 0.09f, 0.85f, -0.36f)
                lineTo(8.0f, 19.0f)
                horizontalLineToRelative(11.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                reflectiveCurveToRelative(-0.45f, -1.0f, -1.0f, -1.0f)
                lineTo(8.0f, 17.0f)
                close()
            }
        }
        return _formatTextdirectionRToL!!
    }

private var _formatTextdirectionRToL: ImageVector? = null
