/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ConnectingAirports: ImageVector
    get() {
        if (_connectingAirports != null) {
            return _connectingAirports!!
        }
        _connectingAirports = materialIcon(name = "Rounded.ConnectingAirports") {
            materialPath {
                moveTo(15.93f, 10.6f)
                curveToRelative(0.39f, 0.0f, 0.66f, 0.37f, 0.55f, 0.74f)
                lineTo(15.4f, 15.0f)
                horizontalLineToRelative(2.85f)
                lineToRelative(0.59f, -0.78f)
                curveToRelative(0.1f, -0.14f, 0.26f, -0.22f, 0.43f, -0.22f)
                curveToRelative(0.36f, 0.0f, 0.62f, 0.35f, 0.52f, 0.7f)
                lineTo(19.4f, 16.0f)
                lineToRelative(0.39f, 1.3f)
                curveToRelative(0.1f, 0.35f, -0.16f, 0.7f, -0.52f, 0.7f)
                curveToRelative(-0.17f, 0.0f, -0.33f, -0.08f, -0.43f, -0.22f)
                lineTo(18.25f, 17.0f)
                horizontalLineTo(15.4f)
                lineToRelative(1.08f, 3.66f)
                curveToRelative(0.11f, 0.37f, -0.17f, 0.74f, -0.55f, 0.74f)
                curveToRelative(-0.2f, 0.0f, -0.39f, -0.11f, -0.5f, -0.28f)
                lineTo(13.0f, 17.0f)
                horizontalLineToRelative(-2.97f)
                curveToRelative(-0.53f, 0.0f, -1.0f, -0.4f, -1.03f, -0.93f)
                curveTo(8.96f, 15.48f, 9.43f, 15.0f, 10.0f, 15.0f)
                horizontalLineToRelative(3.0f)
                lineToRelative(2.43f, -4.12f)
                curveTo(15.54f, 10.71f, 15.73f, 10.6f, 15.93f, 10.6f)
                close()
                moveTo(8.07f, 2.6f)
                curveToRelative(-0.39f, 0.0f, -0.66f, 0.37f, -0.55f, 0.74f)
                lineTo(8.6f, 7.0f)
                horizontalLineTo(5.75f)
                lineTo(5.16f, 6.22f)
                curveTo(5.06f, 6.08f, 4.9f, 6.0f, 4.73f, 6.0f)
                curveTo(4.37f, 6.0f, 4.11f, 6.35f, 4.21f, 6.7f)
                lineTo(4.6f, 8.0f)
                lineTo(4.21f, 9.3f)
                curveTo(4.11f, 9.65f, 4.37f, 10.0f, 4.73f, 10.0f)
                curveToRelative(0.17f, 0.0f, 0.33f, -0.08f, 0.43f, -0.22f)
                lineTo(5.75f, 9.0f)
                horizontalLineTo(8.6f)
                lineToRelative(-1.08f, 3.66f)
                curveToRelative(-0.11f, 0.37f, 0.17f, 0.74f, 0.55f, 0.74f)
                curveToRelative(0.2f, 0.0f, 0.39f, -0.11f, 0.5f, -0.28f)
                lineTo(11.0f, 9.0f)
                horizontalLineToRelative(2.97f)
                curveToRelative(0.53f, 0.0f, 1.0f, -0.4f, 1.03f, -0.93f)
                curveTo(15.04f, 7.48f, 14.57f, 7.0f, 14.0f, 7.0f)
                horizontalLineToRelative(-3.0f)
                lineTo(8.57f, 2.88f)
                curveTo(8.46f, 2.71f, 8.27f, 2.6f, 8.07f, 2.6f)
                close()
            }
        }
        return _connectingAirports!!
    }

private var _connectingAirports: ImageVector? = null
