/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Stroller: ImageVector
    get() {
        if (_stroller != null) {
            return _stroller!!
        }
        _stroller = materialIcon(name = "Outlined.Stroller") {
            materialPath {
                moveTo(18.0f, 20.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveToRelative(0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveTo(18.0f, 18.9f, 18.0f, 20.0f)
                close()
                moveTo(6.0f, 18.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveTo(7.1f, 18.0f, 6.0f, 18.0f)
                close()
                moveTo(15.0f, 8.66f)
                lineTo(9.6f, 15.0f)
                horizontalLineTo(15.0f)
                verticalLineTo(8.66f)
                moveTo(18.65f, 3.0f)
                curveTo(20.52f, 3.0f, 22.0f, 4.56f, 22.0f, 6.48f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(6.48f)
                curveTo(20.0f, 5.66f, 19.42f, 5.0f, 18.65f, 5.0f)
                curveTo(17.97f, 5.0f, 17.58f, 5.59f, 17.0f, 6.27f)
                verticalLineTo(15.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                horizontalLineTo(7.43f)
                curveToRelative(-0.85f, 0.0f, -1.31f, -1.0f, -0.76f, -1.65f)
                lineToRelative(8.8f, -10.32f)
                curveTo(16.11f, 4.27f, 16.99f, 3.0f, 18.65f, 3.0f)
                lineTo(18.65f, 3.0f)
                close()
                moveTo(10.0f, 5.0f)
                curveTo(9.35f, 5.0f, 8.71f, 5.09f, 8.09f, 5.27f)
                lineToRelative(1.4f, 1.4f)
                lineToRelative(1.37f, -1.61f)
                curveTo(10.58f, 5.02f, 10.29f, 5.0f, 10.0f, 5.0f)
                moveTo(10.0f, 3.0f)
                curveToRelative(1.56f, 0.0f, 3.03f, 0.4f, 4.3f, 1.1f)
                lineToRelative(-4.7f, 5.51f)
                lineTo(4.72f, 4.72f)
                curveTo(6.21f, 3.64f, 8.03f, 3.0f, 10.0f, 3.0f)
                lineTo(10.0f, 3.0f)
                close()
            }
        }
        return _stroller!!
    }

private var _stroller: ImageVector? = null
