/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Festival: ImageVector
    get() {
        if (_festival != null) {
            return _festival!!
        }
        _festival = materialIcon(name = "Filled.Festival") {
            materialPath {
                moveTo(13.0f, 5.7f)
                lineToRelative(0.0f, -1.7f)
                lineToRelative(3.0f, 0.0f)
                lineToRelative(-1.0f, -1.49f)
                lineToRelative(1.0f, -1.51f)
                lineToRelative(-5.0f, 0.0f)
                lineToRelative(0.0f, 4.7f)
                lineToRelative(-9.0f, 6.3f)
                lineToRelative(0.0f, 10.0f)
                lineToRelative(7.0f, 0.0f)
                lineToRelative(0.0f, -5.0f)
                lineToRelative(3.03f, -2.0f)
                lineToRelative(2.97f, 2.0f)
                lineToRelative(0.0f, 5.0f)
                lineToRelative(7.0f, 0.0f)
                lineToRelative(0.0f, -10.0f)
                close()
            }
        }
        return _festival!!
    }

private var _festival: ImageVector? = null
