/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Tsunami: ImageVector
    get() {
        if (_tsunami != null) {
            return _tsunami!!
        }
        _tsunami = materialIcon(name = "Sharp.Tsunami") {
            materialPath {
                moveTo(18.67f, 17.63f)
                curveToRelative(-3.8f, 2.8f, -6.12f, 0.4f, -6.67f, 0.0f)
                curveToRelative(-0.66f, 0.49f, -2.92f, 2.76f, -6.67f, 0.0f)
                curveTo(3.43f, 19.03f, 2.65f, 19.0f, 2.0f, 19.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(1.16f, 0.0f, 2.3f, -0.32f, 3.33f, -0.93f)
                curveToRelative(2.06f, 1.22f, 4.61f, 1.22f, 6.67f, 0.0f)
                curveToRelative(2.06f, 1.22f, 4.61f, 1.22f, 6.67f, 0.0f)
                curveTo(19.7f, 20.68f, 20.84f, 21.0f, 22.0f, 21.0f)
                verticalLineToRelative(-2.0f)
                curveTo(21.34f, 19.0f, 20.5f, 18.98f, 18.67f, 17.63f)
                close()
            }
            materialPath {
                moveTo(19.33f, 12.0f)
                horizontalLineTo(22.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-2.67f)
                curveTo(17.5f, 10.0f, 16.0f, 8.5f, 16.0f, 6.67f)
                curveToRelative(0.0f, -1.02f, 0.38f, -1.74f, 1.09f, -3.34f)
                curveTo(15.72f, 3.12f, 15.09f, 3.0f, 14.0f, 3.0f)
                curveTo(7.36f, 3.0f, 2.15f, 8.03f, 2.01f, 14.5f)
                curveToRelative(0.0f, 0.0f, -0.01f, 2.0f, -0.01f, 2.0f)
                curveToRelative(1.16f, 0.0f, 2.3f, -0.32f, 3.33f, -0.93f)
                curveToRelative(2.06f, 1.22f, 4.61f, 1.22f, 6.67f, 0.0f)
                curveToRelative(2.06f, 1.22f, 4.61f, 1.22f, 6.67f, 0.0f)
                curveToRelative(1.03f, 0.61f, 2.17f, 0.93f, 3.33f, 0.93f)
                verticalLineToRelative(-2.0f)
                curveToRelative(-0.66f, 0.0f, -1.5f, -0.02f, -3.33f, -1.37f)
                curveToRelative(-3.8f, 2.8f, -6.12f, 0.4f, -6.67f, 0.0f)
                curveToRelative(-0.9f, 0.67f, -0.54f, 0.41f, -0.91f, 0.63f)
                curveTo(10.39f, 12.82f, 10.0f, 11.7f, 10.0f, 10.5f)
                curveToRelative(0.0f, -2.58f, 1.77f, -4.74f, 4.21f, -5.33f)
                curveTo(14.08f, 5.68f, 14.0f, 6.19f, 14.0f, 6.67f)
                curveTo(14.0f, 9.61f, 16.39f, 12.0f, 19.33f, 12.0f)
                close()
            }
        }
        return _tsunami!!
    }

private var _tsunami: ImageVector? = null
