/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SignalCellularNodata: ImageVector
    get() {
        if (_signalCellularNodata != null) {
            return _signalCellularNodata!!
        }
        _signalCellularNodata = materialIcon(name = "Sharp.SignalCellularNodata") {
            materialPath {
                moveTo(22.0f, 13.0f)
                horizontalLineToRelative(-9.0f)
                verticalLineToRelative(9.0f)
                horizontalLineTo(2.0f)
                lineTo(22.0f, 2.0f)
                verticalLineTo(13.0f)
                close()
                moveTo(21.0f, 15.41f)
                lineTo(19.59f, 14.0f)
                lineToRelative(-2.09f, 2.09f)
                lineTo(15.41f, 14.0f)
                lineTo(14.0f, 15.41f)
                lineToRelative(2.09f, 2.09f)
                lineTo(14.0f, 19.59f)
                lineTo(15.41f, 21.0f)
                lineToRelative(2.09f, -2.08f)
                lineTo(19.59f, 21.0f)
                lineTo(21.0f, 19.59f)
                lineToRelative(-2.08f, -2.09f)
                lineTo(21.0f, 15.41f)
                close()
            }
        }
        return _signalCellularNodata!!
    }

private var _signalCellularNodata: ImageVector? = null
