/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.BakeryDining: ImageVector
    get() {
        if (_bakeryDining != null) {
            return _bakeryDining!!
        }
        _bakeryDining = materialIcon(name = "Sharp.BakeryDining") {
            materialPath {
                moveTo(16.36f, 7.58f)
                lineToRelative(-0.86f, 9.41f)
                lineToRelative(1.5f, 0.0f)
                lineToRelative(3.16f, -7.89f)
                close()
            }
            materialPath {
                moveTo(3.84f, 9.1f)
                lineToRelative(3.16f, 7.89f)
                lineToRelative(1.5f, 0.0f)
                lineToRelative(-0.86f, -9.41f)
                close()
            }
            materialPath {
                moveTo(10.0f, 16.99f)
                lineToRelative(4.0f, 0.0f)
                lineToRelative(1.0f, -10.99f)
                lineToRelative(-6.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(20.32f, 12.75f)
                lineToRelative(-1.81f, 4.5f)
                lineToRelative(1.95f, 0.96f)
                lineToRelative(2.06f, -1.22f)
                close()
            }
            materialPath {
                moveTo(1.48f, 16.99f)
                lineToRelative(2.06f, 1.22f)
                lineToRelative(1.95f, -0.96f)
                lineToRelative(-1.81f, -4.5f)
                close()
            }
        }
        return _bakeryDining!!
    }

private var _bakeryDining: ImageVector? = null
